/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.tfsIntegration.core.TFSVcs;

public class AddAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        final ArrayList errors = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                errors.addAll(TFSVcs.getInstance(project).getCheckinEnvironment().scheduleUnversionedFilesForAddition(Arrays.asList(files)));
            }
        }, "Scheduling addition...", false, project);
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, "TFS");
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        e.getPresentation().setEnabled(AddAction.isEnabled(project, files));
    }

    private static boolean isEnabled(Project project, VirtualFile[] files) {
        if (files.length == 0) {
            return false;
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            FileStatus fileStatus = fileStatusManager.getStatus(file);
            if (fileStatus == FileStatus.UNKNOWN) continue;
            return false;
        }
        return true;
    }
}

