/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.workitems;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WorkItemType {
    private static final Map<String, WorkItemType> ourAllTypes = ContainerUtil.newHashMap();
    public static final WorkItemType BUG = WorkItemType.register("Bug");
    public static final WorkItemType TASK = WorkItemType.register("Task");
    @NonNls
    @NotNull
    private final String myName;

    private WorkItemType(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "<init>"));
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "getName"));
        }
        return string;
    }

    @NotNull
    public static WorkItemType from(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "from"));
        }
        WorkItemType workItemType = WorkItemType.register(typeName);
        if (workItemType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "from"));
        }
        return workItemType;
    }

    @NotNull
    private static synchronized WorkItemType register(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "register"));
        }
        WorkItemType result = ourAllTypes.get(typeName);
        if (result == null) {
            result = new WorkItemType(typeName);
            ourAllTypes.put(typeName, result);
        }
        WorkItemType workItemType = result;
        if (workItemType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemType", "register"));
        }
        return workItemType;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkItemType)) {
            return false;
        }
        WorkItemType type = (WorkItemType)o;
        return this.myName.equals(type.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

