/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.ui.ChooseTeamProjectCollectionForm;

public class ChooseTeamProjectCollectionDialog
extends DialogWrapper {
    private final ChooseTeamProjectCollectionForm myForm;

    public ChooseTeamProjectCollectionDialog(JComponent parent, String serverAddress, Collection<TfsServerConnectionHelper.TeamProjectCollectionDescriptor> items) {
        super((Component)parent, false);
        this.setTitle(TFSBundle.message("choose.team.project.collection.dialog.title", new Object[0]));
        this.setSize(500, 400);
        this.myForm = new ChooseTeamProjectCollectionForm(serverAddress, items);
        this.myForm.addChangeListener(new ChooseTeamProjectCollectionForm.Listener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChooseTeamProjectCollectionDialog.this.revalidate();
            }

            @Override
            public void selected() {
                if (ChooseTeamProjectCollectionDialog.this.getErrorMessage() == null) {
                    ChooseTeamProjectCollectionDialog.this.doOKAction();
                }
            }
        });
        this.init();
        this.revalidate();
    }

    private void revalidate() {
        String message = this.getErrorMessage();
        this.setOKActionEnabled(message == null);
        this.myForm.setErrorMessage(message);
    }

    @Nullable
    private String getErrorMessage() {
        TfsServerConnectionHelper.TeamProjectCollectionDescriptor selected = this.getSelectedItem();
        if (selected == null) {
            return TFSBundle.message("no.team.project.collection.selected", new Object[0]);
        }
        if (TFSConfigurationManager.getInstance().serverKnown(selected.instanceId)) {
            return TFSBundle.message("duplicate.team.project.collection", selected.name);
        }
        return null;
    }

    @Nullable
    public TfsServerConnectionHelper.TeamProjectCollectionDescriptor getSelectedItem() {
        return this.myForm.getSelectedItem();
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ChooseTeamProjectCollection";
    }
}

