/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.ui.ManageWorkspacesDialog;

public class ProjectConfigurableForm {
    private JButton myManageButton;
    private JButton myResetPasswordsButton;
    private final Project myProject;
    private JComponent myContentPane;
    private JCheckBox myUseIdeaHttpProxyCheckBox;
    private JCheckBox myTFSCheckBox;
    private JCheckBox myStatefulCheckBox;
    private JCheckBox myReportNotInstalledPoliciesCheckBox;

    public ProjectConfigurableForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesDialog d = new ManageWorkspacesDialog(ProjectConfigurableForm.this.myProject);
                d.show();
            }
        });
        this.myUseIdeaHttpProxyCheckBox.setSelected(TFSConfigurationManager.getInstance().useIdeaHttpProxy());
        this.myResetPasswordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = "Reset Stored Passwords";
                if (Messages.showYesNoDialog((Project)ProjectConfigurableForm.this.myProject, (String)"Do you want to reset all stored passwords?", (String)"Reset Stored Passwords", (Icon)Messages.getQuestionIcon()) == 0) {
                    TFSConfigurationManager.getInstance().resetStoredPasswords();
                    Messages.showInfoMessage((Project)ProjectConfigurableForm.this.myProject, (String)"Passwords reset successfully.", (String)"Reset Stored Passwords");
                }
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectConfigurableForm.this.updateNonInstalledCheckbox();
            }
        };
        this.myStatefulCheckBox.addActionListener(l);
        this.myTFSCheckBox.addActionListener(l);
    }

    private void updateNonInstalledCheckbox() {
        if (!this.myStatefulCheckBox.isSelected() && !this.myTFSCheckBox.isSelected()) {
            this.myReportNotInstalledPoliciesCheckBox.setSelected(false);
            this.myReportNotInstalledPoliciesCheckBox.setEnabled(false);
        } else {
            this.myReportNotInstalledPoliciesCheckBox.setEnabled(true);
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public boolean useProxy() {
        return this.myUseIdeaHttpProxyCheckBox.isSelected();
    }

    public void setUserProxy(boolean value) {
        this.myUseIdeaHttpProxyCheckBox.setSelected(value);
    }

    public boolean supportTfsCheckinPolicies() {
        return this.myTFSCheckBox.isSelected();
    }

    public boolean supportStatefulCheckinPolicies() {
        return this.myStatefulCheckBox.isSelected();
    }

    public boolean reportNotInstalledCheckinPolicies() {
        return this.myReportNotInstalledPoliciesCheckBox.isSelected();
    }

    public void setSupportTfsCheckinPolicies(boolean supportTfsCheckinPolicies) {
        this.myTFSCheckBox.setSelected(supportTfsCheckinPolicies);
        this.updateNonInstalledCheckbox();
    }

    public void setSupportStatefulCheckinPolicies(boolean supportStatefulCheckinPolicies) {
        this.myStatefulCheckBox.setSelected(supportStatefulCheckinPolicies);
        this.updateNonInstalledCheckbox();
    }

    public void setReportNotInstalledCheckinPolicies(boolean reportNotInstalledCheckinPolicies) {
        this.myReportNotInstalledPoliciesCheckBox.setSelected(reportNotInstalledCheckinPolicies);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton;
        JCheckBox jCheckBox4;
        JButton jButton2;
        JPanel jPanel = new JPanel();
        this.myContentPane = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Servers and workspaces", (int)0, (int)0, null, null));
        this.myManageButton = jButton2 = new JButton();
        jButton2.setText("Manage...");
        jButton2.setMnemonic('M');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUseIdeaHttpProxyCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use HTTP Proxy settings");
        jCheckBox4.setMnemonic('U');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        ((Component)jCheckBox4).setEnabled(true);
        jCheckBox4.setSelected(false);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Passwords", (int)0, (int)0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myResetPasswordsButton = jButton = new JButton();
        jButton.setText("Reset Saved Passwords");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Checkin policies compatibility", (int)0, (int)0, null, null));
        this.myReportNotInstalledPoliciesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Warn about not installed policies");
        jCheckBox3.setMnemonic('W');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("(Note: these settings may be overridden for individual team project)");
        jPanel5.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTFSCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Evaluate Team Explorer policies");
        jCheckBox2.setMnemonic('T');
        jCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStatefulCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Evaluate Teamprise policies");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(10);
        jPanel5.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

