/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.util.Key;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramEdgeBase<T>
implements DiagramEdge<T> {
    private final THashMap myUserData = new THashMap();
    protected final DiagramNode<T> mySource;
    protected final DiagramNode<T> myTarget;
    protected final DiagramRelationshipInfo myRelationship;
    private final String myDebugInfo;
    private Object mySourceAnchor = null;
    private Object myTargetAnchor = null;
    private Color myAnchorColor = null;

    public DiagramEdgeBase(DiagramNode<T> source, DiagramNode<T> target, DiagramRelationshipInfo relationship) {
        this.mySource = source;
        this.myTarget = target;
        this.myRelationship = relationship;
        if (source instanceof DiagramNodeBase && target instanceof DiagramNodeBase) {
            String fqn1 = source instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)source).getFQN();
            String fqn2 = target instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)target).getFQN();
            this.myDebugInfo = fqn1 + " -> " + fqn2 + " (" + this.myRelationship + ")";
        } else {
            this.myDebugInfo = this.toString();
        }
    }

    @Override
    public DiagramNode<T> getSource() {
        return this.mySource;
    }

    @Override
    public DiagramNode<T> getTarget() {
        return this.myTarget;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public T getIdentifyingElement() {
        T t = this.getSource().getIdentifyingElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramEdgeBase", "getIdentifyingElement"));
        }
        return t;
    }

    @Override
    @NotNull
    public DiagramRelationshipInfo getRelationship() {
        DiagramRelationshipInfo diagramRelationshipInfo = this.myRelationship;
        if (diagramRelationshipInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramEdgeBase", "getRelationship"));
        }
        return diagramRelationshipInfo;
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramEdgeBase", "getUserData"));
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diagram/DiagramEdgeBase", "putUserData"));
        }
        this.myUserData.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            DiagramEdge e = (DiagramEdge)obj;
            DiagramNode source = e.getSource();
            DiagramNode target = e.getTarget();
            DiagramRelationshipInfo relationship = e.getRelationship();
            return source != null && source.equals(this.getSource()) && target != null && target.equals(this.getTarget()) && relationship.equals(this.getRelationship());
        }
        return false;
    }

    public int hashCode() {
        return 961 * this.getSource().hashCode() + 31 * this.getTarget().hashCode() + this.getRelationship().hashCode();
    }

    public String toString() {
        return this.myDebugInfo;
    }

    @Override
    public Object getSourceAnchor() {
        return this.mySourceAnchor;
    }

    public void setSourceAnchor(Object sourceAnchor) {
        this.mySourceAnchor = sourceAnchor;
    }

    @Override
    public Object getTargetAnchor() {
        return this.myTargetAnchor;
    }

    public void setTargetAnchor(Object targetAnchor) {
        this.myTargetAnchor = targetAnchor;
    }

    @Override
    public Color getAnchorColor() {
        return this.myAnchorColor;
    }

    public void setAnchorColor(Color anchorColor) {
        this.myAnchorColor = anchorColor;
    }
}

