/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil;", "", "()V", "Companion", "52a7eb3df0584991-compileKotlin"})
public final class SequentialParserUtil {
    private static final int PUNCTUATION_MASK = 1676673024;
    public static final Companion Companion = new Companion(null);

    static {
        PUNCTUATION_MASK = 1676673024;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004J\u001a\u0010\u0015\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil$Companion;", "", "()V", "PUNCTUATION_MASK", "", "getPUNCTUATION_MASK", "()I", "filterBlockquotes", "", "Lkotlin/ranges/IntRange;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "textRange", "indicesToTextRanges", "indices", "", "isPunctuation", "", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "lookup", "isWhitespace", "textRangesToIndices", "ranges", "52a7eb3df0584991-compileKotlin"})
    public static final class Companion {
        private final int getPUNCTUATION_MASK() {
            return PUNCTUATION_MASK;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Integer> textRangesToIndices(@NotNull Collection<IntRange> ranges) {
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            ArrayList<Integer> result = new ArrayList<Integer>();
            block0: for (IntRange range : ranges) {
                int n;
                int n2 = range.getStart();
                if (n2 > (n = range.getEndInclusive() - 1)) continue;
                while (true) {
                    void i;
                    result.add((int)i);
                    if (i == n) continue block0;
                    ++i;
                }
            }
            return CollectionsKt.sorted((Iterable)result);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<IntRange> indicesToTextRanges(@NotNull List<Integer> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int starting = 0;
            int n = 0;
            int n2 = indices.size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (i + true == indices.size() || ((Number)indices.get((int)i)).intValue() + 1 != ((Number)indices.get((int)(i + true))).intValue()) {
                        result.add(new IntRange(((Number)indices.get(starting)).intValue(), ((Number)indices.get((int)i)).intValue() + 1));
                        starting = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return result;
        }

        public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return c == (char)0 || Character.isSpaceChar(c) || Character.isWhitespace(c);
        }

        public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return (this.getPUNCTUATION_MASK() >> Character.getType(c) & 1) != 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<IntRange> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull IntRange textRange) {
            Intrinsics.checkParameterIsNotNull((Object)tokensCache, (String)"tokensCache");
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int lastStart = textRange.getStart();
            int R = textRange.getEndInclusive();
            int n = lastStart;
            int n2 = R - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (Intrinsics.areEqual((Object)new TokensCache.Iterator(tokensCache, (int)i).getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                        if (lastStart < i) {
                            result.add(new IntRange(lastStart, (int)i));
                        }
                        lastStart = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (lastStart < R) {
                result.add(new IntRange(lastStart, R));
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

