/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.CssPatterns;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CssRulesetPattern
extends PsiElementPattern<CssRuleset, CssRulesetPattern> {
    public CssRulesetPattern() {
        super(CssRuleset.class);
    }

    public CssRulesetPattern withSelectors(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/CssRulesetPattern", "withSelectors"));
        }
        return (CssRulesetPattern)this.with((PatternCondition)new PatternCondition<CssRuleset>("withSelectors"){

            public boolean accepts(@NotNull CssRuleset cssRuleset, ProcessingContext context) {
                if (cssRuleset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssRuleset", "com/jetbrains/quirksmode/CssRulesetPattern$1", "accepts"));
                }
                return pattern.accepts(Arrays.asList(cssRuleset.getSelectors()), context);
            }
        });
    }

    public CssRulesetPattern withDeclaration(final @NotNull String name, final String ... values) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/quirksmode/CssRulesetPattern", "withDeclaration"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/quirksmode/CssRulesetPattern", "withDeclaration"));
        }
        return (CssRulesetPattern)this.with((PatternCondition)new PatternCondition<CssRuleset>("withDeclaration"){

            public boolean accepts(@NotNull CssRuleset cssRuleset, ProcessingContext context) {
                if (cssRuleset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssRuleset", "com/jetbrains/quirksmode/CssRulesetPattern$2", "accepts"));
                }
                CssBlock block = cssRuleset.getBlock();
                if (block != null) {
                    for (CssDeclaration declaration : block.getDeclarations()) {
                        if (!CssPatterns.cssDeclaration(name, values).accepts(declaration)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

