/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ProjectBasedConnectionOwner;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionOwnerFactory {
    public static ConnectionOwner createConnectionOwner(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "createConnectionOwner"));
        }
        return new ProjectBasedConnectionOwner(project);
    }

    public static ConnectionOwner createConnectionOwner(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "createConnectionOwner"));
        }
        return new ComponentBasedConnectionOwner(component);
    }

    public static ConnectionOwner createConnectionOwner(@Nullable Project project, @NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "createConnectionOwner"));
        }
        if (project != null) {
            return ConnectionOwnerFactory.createConnectionOwner(project);
        }
        return ConnectionOwnerFactory.createConnectionOwner(component);
    }

    public static boolean computeOnEDT(@NotNull Computable<Boolean> computable, @Nullable ProgressIndicator progressIndicator, @NotNull ModalityState defaultModalityState) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "computeOnEDT"));
        }
        if (defaultModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModalityState", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "computeOnEDT"));
        }
        return ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator, defaultModalityState, null);
    }

    public static boolean computeOnEDT(@NotNull Computable<Boolean> computable, @Nullable ProgressIndicator progressIndicator, @NotNull ModalityState defaultModalityState, @Nullable ModalityState forcedModality) {
        ModalityState modalityState;
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "computeOnEDT"));
        }
        if (defaultModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModalityState", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "computeOnEDT"));
        }
        if (forcedModality != null) {
            modalityState = forcedModality;
        } else if (progressIndicator != null && !progressIndicator.isCanceled()) {
            WaitForProgressToShow.execute((ProgressIndicator)progressIndicator);
            modalityState = progressIndicator.getModalityState();
        } else {
            modalityState = defaultModalityState;
        }
        Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "lambda$computeOnEDT$0"));
            }
            result.set(computable.compute());
        }, modalityState);
        return (Boolean)result.get();
    }

    public static void invokeLater(@NotNull Runnable r, @Nullable ProgressIndicator progressIndicator, @NotNull ModalityState defaultModalityState) {
        ModalityState modalityState;
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "invokeLater"));
        }
        if (defaultModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModalityState", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory", "invokeLater"));
        }
        if (progressIndicator != null && !progressIndicator.isCanceled()) {
            WaitForProgressToShow.execute((ProgressIndicator)progressIndicator);
            modalityState = progressIndicator.getModalityState();
        } else {
            modalityState = defaultModalityState;
        }
        ApplicationManager.getApplication().invokeLater(r, modalityState);
    }

    private static final class ComponentBasedConnectionOwner
    implements ConnectionOwner {
        @NotNull
        private final Component myComponent;

        public ComponentBasedConnectionOwner(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "<init>"));
            }
            this.myComponent = component;
        }

        @Override
        public boolean promptYesNo(@NotNull String message, @NotNull String title, @Nullable ProgressIndicator progressIndicator) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "promptYesNo"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "promptYesNo"));
            }
            Computable computable = () -> {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "lambda$promptYesNo$0"));
                }
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "lambda$promptYesNo$0"));
                }
                return Messages.showYesNoDialog((Component)this.myComponent, (String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
            };
            return ConnectionOwnerFactory.computeOnEDT((Computable<Boolean>)computable, progressIndicator, ModalityState.stateForComponent((Component)this.myComponent));
        }

        @Override
        public void showMessage(@NotNull String message, @NotNull String title, @Nullable Mappable config, @Nullable ProgressIndicator progressIndicator, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "showMessage"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "showMessage"));
            }
            Runnable r = () -> {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "lambda$showMessage$1"));
                }
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ConnectionOwnerFactory$ComponentBasedConnectionOwner", "lambda$showMessage$1"));
                }
                Messages.showInfoMessage((Component)this.myComponent, (String)message, (String)title);
            };
            ConnectionOwnerFactory.invokeLater(r, progressIndicator, ModalityState.stateForComponent((Component)this.myComponent));
        }

        @Override
        @Nullable
        public String getHash() {
            return String.valueOf(this.myComponent.hashCode());
        }

        @Override
        public void registerDisposable(final @Nullable Disposable disposable) {
            if (disposable == null) {
                return;
            }
            new UiNotifyConnector(this.myComponent, (Activatable)new Activatable.Adapter(){

                public void hideNotify() {
                    disposable.dispose();
                }
            });
        }

        @Override
        @Nullable
        public Project getProjectForDialogCreation() {
            return null;
        }

        @Override
        @Nullable
        public Component getComponentForDialogCreation() {
            return this.myComponent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentBasedConnectionOwner other = (ComponentBasedConnectionOwner)o;
            return this.myComponent.equals(other.myComponent);
        }

        public int hashCode() {
            return this.myComponent.hashCode();
        }
    }
}

