/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ServerBrowserTask;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendedNotificationBrowserTask
extends ServerBrowserTask {
    private final boolean myIsModalContext;
    private final Component myComponent;
    private final String myErrorTitle;

    protected ExtendedNotificationBrowserTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, PublishConfig publishConfig, Deployable server, String title, boolean isModalContext, Component component, String errorTitle, @NotNull DeploymentRevisionTracker revisionTracker, boolean serverSideModification, boolean silent) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ExtendedNotificationBrowserTask", "<init>"));
        }
        if (revisionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/ExtendedNotificationBrowserTask", "<init>"));
        }
        super(project, connectionOwner, publishConfig, server, title, revisionTracker, serverSideModification, silent);
        this.myIsModalContext = isModalContext;
        this.myComponent = component;
        this.myErrorTitle = errorTitle;
    }

    @Override
    protected void showBalloon(MessageType type, String text, boolean isSummary) {
        if (this.myIsModalContext) {
            if (type == MessageType.ERROR) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myComponent, (String)text, (String)this.myErrorTitle));
            } else if (type == MessageType.WARNING) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showWarningDialog((Component)this.myComponent, (String)text, (String)this.myErrorTitle));
            }
        } else {
            super.showBalloon(type, text, isSummary);
        }
    }
}

