/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBasedConnectionOwner
implements ConnectionOwner {
    @Nullable
    private final Project myProject;

    protected ProjectBasedConnectionOwner(@Nullable Project project) {
        this.myProject = project;
    }

    @Override
    public boolean promptYesNo(@NotNull String message, @NotNull String title, @Nullable ProgressIndicator progressIndicator) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "promptYesNo"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "promptYesNo"));
        }
        Computable computable = () -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "lambda$promptYesNo$0"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "lambda$promptYesNo$0"));
            }
            ProgressManager.checkCanceled();
            if (this.myProject != null) {
                return Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
            }
            return Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
        };
        ProgressManager.checkCanceled();
        return ConnectionOwnerFactory.computeOnEDT((Computable<Boolean>)computable, progressIndicator, ModalityState.any(), ModalityState.any());
    }

    @Override
    public final void showMessage(@NotNull String message, @NotNull String title, @Nullable Mappable config, @Nullable ProgressIndicator progressIndicator, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "showMessage"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "showMessage"));
        }
        ConnectionOwnerFactory.invokeLater(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "lambda$showMessage$1"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "lambda$showMessage$1"));
            }
            this.showMessageImpl(message, title, config, doNotAskOption);
        }, progressIndicator, ModalityState.defaultModalityState());
    }

    protected void showMessageImpl(@NotNull String message, @NotNull String title, @Nullable Mappable config, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "showMessageImpl"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/ProjectBasedConnectionOwner", "showMessageImpl"));
        }
        FileTransferToolWindow.print(this.myProject, config, message, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    @Nullable
    public final String getHash() {
        return this.myProject != null && !this.myProject.isDisposed() ? this.myProject.getLocationHash() : null;
    }

    @Override
    public final void registerDisposable(@Nullable Disposable disposable) {
        if (disposable == null) {
            return;
        }
        if (this.myProject == null || this.myProject.isDefault()) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)disposable);
        } else {
            Disposer.register((Disposable)this.myProject, (Disposable)disposable);
        }
    }

    @Override
    @Nullable
    public Project getProjectForDialogCreation() {
        return this.myProject;
    }

    @Override
    @Nullable
    public Component getComponentForDialogCreation() {
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectBasedConnectionOwner)) {
            return false;
        }
        ProjectBasedConnectionOwner other = (ProjectBasedConnectionOwner)o;
        if (this.myProject == null) {
            return other.myProject == null;
        }
        return this.myProject.equals(other.myProject);
    }

    public final int hashCode() {
        return this.myProject != null ? this.myProject.hashCode() : 0;
    }
}

