/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileSystemOptions;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Connectable
extends Cloneable {
    @Nls
    public String getName();

    @NotNull
    public Icon getIcon();

    @NotNull
    public FileSystemOptions getConnectionOptions(@NotNull ConnectionOwner var1, @NotNull String var2, FileTransferConfig.Origin var3, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> var4, @Nullable ProgressIndicator var5);

    public boolean hasCredentials();

    @Nullable
    public Credentials getCredentials();

    public void setCredentials(Credentials var1, boolean var2, boolean var3, boolean var4);

    public void clearPasswordIfNotStored();

    @NotNull
    public AccessType getAccessType();

    public boolean isProjectLevel();

    public String getHost();

    public String getLiteralPort();

    public boolean isUseKeyPair();

    public String getPrivateKeyFile();

    public boolean isDefaultRootFolder();

    public boolean isCaseSensitive();

    public String getRootUri();

    public int getMaxConnections();

    public AdvancedOptionsConfig.AccurateTimestamps getAccurateTimestamps();

    @NotNull
    public Connectable clone();

    public boolean isBasedOnServer(WebServerConfig var1);

    public String validateInternalSlow(long var1) throws TimeoutException;

    public String validateInternalSlow(long var1, boolean var3) throws TimeoutException;

    public String validateSlow(long var1) throws TimeoutException;

    public String validateFastInternal();

    public String validateFastInternal(boolean var1);

    public String validateFast();

    default public boolean needsTransfer() {
        return PublishUtils.needsTransfer(this.getAccessType());
    }

    public boolean isAnonymous();

    public String getKnownHostsFile();
}

