/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mappable {
    @Nullable
    public String getId();

    @Nls
    public String getName();

    @NotNull
    public Icon getIcon();

    public boolean isCaseSensitive();

    @NotNull
    public AccessType getAccessType();

    default public String getPresentablePath(FileObject file) {
        return this.getPresentablePath(file.getName());
    }

    public String getPresentablePath(FileName var1);

    public String getPresentablePath(WebServerConfig.RemotePath var1);

    public String getFullPath(String var1);

    @Nullable
    public String validateUrl();

    public String getUrl();

    default public WebServerConfig.RemotePath getRemotePath(FileObject file) {
        return this.getRemotePath(file.getName());
    }

    default public WebServerConfig.RemotePath getRemotePath(FileName fileName) {
        if (this.getAccessType().isProtocolBased()) {
            return new WebServerConfig.RemotePath(fileName.getPath());
        }
        return new WebServerConfig.RemotePath(DeploymentPathUtils.getLocalPath(fileName));
    }

    public WebServerConfig.RemotePath getRootPath();

    @Nullable
    default public String getMountedFolder() {
        return null;
    }
}

