/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.FileSystemDebugComparator;
import com.jetbrains.plugins.webDeployment.connections.FlexibleSemaphore;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoteConnectionPool {
    private static final Logger LOG = Logger.getInstance((String)RemoteConnection.class.getName());
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private static final int INITIAL_WAITING_RCONNECT_TIMEOUT_SECONDS = 3;
    private final Collection<RemoteConnection> myConnections;
    private final Object myConnectionsAndFSLock;
    private final FlexibleSemaphore mySemaphore;
    private final Connectable myConnectable;
    @NotNull
    private final String myTitle;
    private final FileTransferConfig.Origin myOrigin;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    private boolean myCloseFSOnNoConnections;
    private final AtomicReference<FileSystem> myFileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.myConnectionsAndFSLock;
        synchronized (object) {
            for (RemoteConnection connection : this.myConnections) {
                connection.release();
            }
            this.closeFileSystemIfEmpty(true);
        }
    }

    RemoteConnectionPool(@NotNull Connectable connectable, @NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin origin) {
        if (connectable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectable", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        this.myConnections = new ArrayList<RemoteConnection>();
        this.myConnectionsAndFSLock = new Object();
        this.myFileSystem = new AtomicReference();
        this.myConnectable = connectable.clone();
        this.myConnectionOwner = connectionOwner;
        this.myTitle = title;
        this.myOrigin = origin;
        this.mySemaphore = new FlexibleSemaphore(this.myConnectable.getMaxConnections());
        this.myCloseFSOnNoConnections = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerUpdated(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "notifyServerUpdated"));
        }
        if (!this.myConnectable.isBasedOnServer(server)) {
            return;
        }
        int maxConnections = server.getFileTransferConfig().getAdvancedOptions().getMaxConnections();
        this.mySemaphore.setAvailable(maxConnections);
        Object object = this.myConnectionsAndFSLock;
        synchronized (object) {
            if (!this.myCloseFSOnNoConnections) {
                Deployable newConnectable;
                FileSystemOptions newOptions;
                FileSystemOptions options = this.myConnectable.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, null, null);
                if (options.equals((Object)(newOptions = (newConnectable = Deployable.create(server)).getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, null, null)))) {
                    return;
                }
                this.myCloseFSOnNoConnections = true;
                this.closeFileSystemIfEmpty(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConnection createConnection(@Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        Object object = this.myConnectionsAndFSLock;
        synchronized (object) {
            if (!this.myConnections.isEmpty()) {
                LOG.debug("Reusing connection to " + this.myConnectable.getRootUri() + this.getInDebugHash());
                RemoteConnection existing = this.myConnections.iterator().next();
                return existing.clone();
            }
            LOG.debug("Opening connection to " + this.myConnectable.getRootUri() + this.getInDebugHash());
            FileSystemManager manager = PublishUtils.getManager();
            FileObject root = null;
            FileSystemException exception = null;
            int iteration = 0;
            while (iteration == 0 || iteration < 5 && RemoteConnectionPool.shouldRetryConnecting(exception)) {
                try {
                    RemoteConnectionPool.waitBeforeNextAttempt(pi, ++iteration);
                    RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("connecting", new Object[0]));
                    root = manager.resolveFile(this.myConnectable.getRootUri(), this.myConnectable.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, forceDisconnectDispatcher, pi));
                    root.getChild(".");
                    exception = null;
                    break;
                }
                catch (FileSystemException e) {
                    LOG.warn("Retrying connecting to " + this.myConnectable.getRootUri() + this.getInDebugHash() + ": " + iteration + " iterations", (Throwable)e);
                    exception = e;
                }
            }
            RemoteConnectionPool.setProgressSecondText(pi, null);
            if (exception != null) {
                if (root != null) {
                    RemoteConnectionPool.closeFileSystem(root.getFileSystem());
                }
                throw exception;
            }
            RemoteConnectionImpl connection = new RemoteConnectionImpl(root.getName());
            if (!this.myFileSystem.compareAndSet(null, root.getFileSystem()) && this.myFileSystem.get() != root.getFileSystem()) {
                RemoteConnectionPool.closeFileSystem(root.getFileSystem());
                LOG.error(FileSystemDebugComparator.getDivergeDescription(root.getFileSystem(), this.myFileSystem.get()));
            }
            this.myConnections.add(connection);
            LOG.debug("Added connection to pool of" + this.myConnectable.getRootUri() + this.getInDebugHash() + "; " + this.myConnections.size() + " connections exists");
            this.myCloseFSOnNoConnections = false;
            return connection;
        }
    }

    private static void waitBeforeNextAttempt(@Nullable ProgressIndicator pi, int iteration) {
        int timeout;
        RemoteConnectionPool.checkProgressCancelled(pi);
        if (iteration == 1) {
            return;
        }
        RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
        if (pi != null) {
            for (timeout = pi == null ? 3 : (int)Math.pow(3.0, iteration); timeout > 0; --timeout) {
                RemoteConnectionPool.checkProgressCancelled(pi);
                RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
                RemoteConnectionPool.sleep(1);
            }
        } else {
            RemoteConnectionPool.sleep(timeout);
        }
        RemoteConnectionPool.checkProgressCancelled(pi);
    }

    private static String getPresentableTime(int timeout) {
        if (timeout > 120) {
            return WDBundle.message("0.minutes", timeout / 60);
        }
        if (timeout > 60) {
            return WDBundle.message("a.minute", new Object[0]);
        }
        if (timeout == 1) {
            return WDBundle.message("a.second", new Object[0]);
        }
        return WDBundle.message("0.seconds", timeout);
    }

    private static void sleep(int timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void setProgressSecondText(@Nullable ProgressIndicator pi, @Nls String text) {
        if (pi != null) {
            pi.setText2(text);
        }
    }

    private static void checkProgressCancelled(@Nullable ProgressIndicator pi) {
        if (pi != null) {
            pi.checkCanceled();
        }
    }

    private static boolean shouldRetryConnecting(FileSystemException exception) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ConnectException) && !(cause instanceof FTPConnectionClosedException)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(RemoteConnection connection) {
        Object object = this.myConnectionsAndFSLock;
        synchronized (object) {
            boolean removed = this.myConnections.remove(connection);
            if (removed) {
                LOG.debug("Releasing one of the connections to " + this.myConnectable.getRootUri() + this.getInDebugHash() + "; connections left " + this.myConnections.size());
            }
            this.closeFileSystemIfEmpty(false);
        }
    }

    private static void closeFileSystem(@Nullable FileSystem fileSystem) {
        if (fileSystem == null) {
            return;
        }
        PublishUtils.getManager().closeFileSystem(fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileSystemIfEmpty(boolean forceClosingOnNonEmpty) {
        Object object = this.myConnectionsAndFSLock;
        synchronized (object) {
            if (forceClosingOnNonEmpty || this.myCloseFSOnNoConnections && this.myConnections.isEmpty()) {
                if (forceClosingOnNonEmpty) {
                    LOG.warn("Forced closing file system of " + this.myConnectable.getRootUri() + this.getInDebugHash());
                } else {
                    LOG.debug("Empty connection pool for " + this.myConnectable.getRootUri() + this.getInDebugHash());
                }
                FileSystem oldFS = this.myFileSystem.getAndSet(null);
                RemoteConnectionPool.closeFileSystem(oldFS);
                LOG.debug("File system of " + this.myConnectable.getRootUri() + this.getInDebugHash() + " is closed.");
            }
        }
    }

    public String toString() {
        return "Pool for " + this.myConnectable.getRootUri() + this.getInDebugHash();
    }

    private String getInDebugHash() {
        return " in @" + Integer.toHexString(this.hashCode());
    }

    private class RemoteConnectionImpl
    extends RemoteConnection {
        private final AtomicBoolean myIsReleased;
        private final Object myLock;

        private RemoteConnectionImpl(FileName rootName) {
            super(rootName);
            this.myIsReleased = new AtomicBoolean(false);
            this.myLock = new Object();
        }

        @Override
        public FileSystem getFileSystem() {
            return (FileSystem)RemoteConnectionPool.this.myFileSystem.get();
        }

        @Override
        public void release() {
            this.myIsReleased.set(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Object object = this.myLock;
                synchronized (object) {
                    RemoteConnectionPool.this.releaseConnection(this);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T executeServerOperation(ThrowableComputable<T, FileSystemException> computable, @Nullable ProgressIndicator pi) throws FileSystemException {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myIsReleased.get()) {
                    if (pi != null) {
                        pi.cancel();
                    }
                    throw new ProcessCanceledException();
                }
                String originalText = pi != null ? pi.getText() : null;
                try {
                    if (pi != null) {
                        pi.setText(WDBundle.message("waiting.for.free.connection", new Object[0]));
                    }
                    RemoteConnectionPool.this.mySemaphore.take();
                }
                finally {
                    if (pi != null) {
                        pi.setText(originalText);
                    }
                }
                Object object2 = computable.compute();
                return (T)object2;
                finally {
                    RemoteConnectionPool.this.mySemaphore.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RemoteConnection clone() {
            RemoteConnectionImpl result = new RemoteConnectionImpl(this.getRootName());
            Object object = RemoteConnectionPool.this.myConnectionsAndFSLock;
            synchronized (object) {
                RemoteConnectionPool.this.myConnections.add(result);
                LOG.debug("Added cloned connection to pool of" + RemoteConnectionPool.this.myConnectable.getRootUri() + RemoteConnectionPool.this.getInDebugHash() + "; " + RemoteConnectionPool.this.myConnections.size() + " connections exists");
                RemoteConnectionPool.this.myCloseFSOnNoConnections = false;
            }
            return result;
        }
    }
}

