/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcBeanInterface;
import org.w3c.tools.jdbc.JdbcBeanUtil;
import org.w3c.tools.jdbc.JdbcServer;
import org.w3c.tools.jdbc.PropertyCache;
import org.w3c.tools.jdbc.SQL;

public class JdbcBeanSerializer
implements PropertyChangeListener {
    private boolean modified = false;
    protected JdbcBeanInterface bean = null;
    private JdbcBeanInterface[] beans = null;
    protected static final int NOTHING = -1;
    protected static final int INTERSECT = 10;
    protected static final int UNION = 20;
    protected static final int EXCEPT = 30;
    protected int[] priority = new int[]{-1, -1, -1};
    protected JdbcBeanSerializer intersect_serializer = null;
    protected JdbcBeanSerializer union_serializer = null;
    protected JdbcBeanSerializer except_serializer = null;
    protected ResultSet result = null;
    private Vector beantables = null;
    private static Hashtable foreignKeys = new Hashtable();

    private void registerForeignKeys(Class clazz, Class clazz2) {
        Integer n = new Integer(clazz.hashCode() & clazz2.hashCode());
        if (!foreignKeys.containsKey(n)) {
            foreignKeys.put(n, this.computeForeignKeys(clazz, clazz2));
        }
    }

    private String[] getForeignKeys(Class clazz, Class clazz2) {
        Integer n = new Integer(clazz.hashCode() & clazz2.hashCode());
        String[] stringArray = (String[])foreignKeys.get(n);
        if (stringArray == null) {
            stringArray = this.computeForeignKeys(clazz, clazz2);
            foreignKeys.put(n, stringArray);
        }
        return stringArray;
    }

    private String[] computeForeignKeys(Class clazz, Class clazz2) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            BeanInfo beanInfo2 = Introspector.getBeanInfo(clazz2);
            PropertyDescriptor[] propertyDescriptorArray2 = beanInfo2.getPropertyDescriptors();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                for (int j = 0; j < propertyDescriptorArray2.length; ++j) {
                    PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray2[j];
                    if (propertyDescriptor2.isHidden() || propertyDescriptor.isHidden() || !JdbcBeanSerializer.equalsForeignKeys(propertyDescriptor.getName(), propertyDescriptor2.getName())) continue;
                    vector.addElement(propertyDescriptor.getName());
                }
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (IntrospectionException introspectionException) {
            return new String[0];
        }
    }

    private static boolean equalsForeignKeys(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf("_");
        if (n2 != -1) {
            string = string.substring(n2);
        }
        if ((n = string2.lastIndexOf("_")) != -1) {
            string2 = string2.substring(n);
        }
        return string.equals(string2);
    }

    protected void markModified(boolean bl) {
        this.modified = bl;
    }

    protected boolean isModified() {
        return this.modified;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == this.bean) {
            if (object2 == null) {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                if (JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType())) {
                    this.beans = null;
                    JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)propertyChangeEvent.getOldValue();
                    if (jdbcBeanInterface != null) {
                        PropertyCache.removeProperties(jdbcBeanInterface);
                        jdbcBeanInterface.removePropertyChangeListener(this);
                    }
                }
            } else if (object2 instanceof JdbcBeanInterface) {
                this.registerForeignKeys(this.bean.getClass(), object2.getClass());
                this.beans = null;
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)propertyChangeEvent.getOldValue();
                JdbcBeanInterface jdbcBeanInterface2 = (JdbcBeanInterface)object2;
                if (jdbcBeanInterface != null) {
                    PropertyCache.removeProperties(jdbcBeanInterface);
                    jdbcBeanInterface.removePropertyChangeListener(this);
                }
                jdbcBeanInterface2.addPropertyChangeListener(this);
            } else {
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)object;
                PropertyCache.addProperty(jdbcBeanInterface, string, propertyChangeEvent.getNewValue());
                this.markModified(true);
            }
        } else {
            this.markModified(true);
        }
    }

    private String[] getSQLOperatorNValue(JdbcBeanInterface jdbcBeanInterface, PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            Object object = PropertyCache.getProperty(jdbcBeanInterface, propertyDescriptor);
            if (object == null) {
                return null;
            }
            return SQL.getSQLOperator(object);
        }
        return null;
    }

    private String getSQLValue(JdbcBeanInterface jdbcBeanInterface, PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            Object object = PropertyCache.getProperty(jdbcBeanInterface, propertyDescriptor);
            if (object == null) {
                return null;
            }
            return SQL.getSQLValue(object);
        }
        return null;
    }

    private void append(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4).append(" ");
        }
        stringBuffer.append(string).append(string2).append(string3).append(" ");
    }

    private void appendInsert(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", ").append(string);
            stringBuffer2.append(", ").append(string2);
        } else {
            stringBuffer.append("(").append(string);
            stringBuffer2.append("(").append(string2);
        }
    }

    private JdbcBeanInterface[] getJdbcBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            Vector<Object> vector = new Vector<Object>();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Object object;
                Method method;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden() || !JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType()) || (method = propertyDescriptor.getReadMethod()) == null || (object = method.invoke((Object)this.bean, (Object[])null)) == null) continue;
                vector.addElement(object);
            }
            this.beans = new JdbcBeanInterface[vector.size()];
            vector.copyInto(this.beans);
            return this.beans;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private void appendForeignKeys(Vector vector, StringBuffer stringBuffer, String[] stringArray) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        this.appendForeignKeys(vector, stringBuffer, propertyDescriptorArray, stringArray);
    }

    private void appendForeignKeys(Vector vector, StringBuffer stringBuffer, PropertyDescriptor[] propertyDescriptorArray, String[] stringArray) throws IntrospectionException {
        JdbcBeanInterface[] jdbcBeanInterfaceArray = this.getJdbcBeans();
        if (jdbcBeanInterfaceArray != null) {
            for (int i = 0; i < jdbcBeanInterfaceArray.length; ++i) {
                PropertyDescriptor[] propertyDescriptorArray2;
                JdbcBeanInterface jdbcBeanInterface = jdbcBeanInterfaceArray[i];
                String[] stringArray2 = this.getForeignKeys(jdbcBeanInterface.getClass(), this.bean.getClass());
                for (int j = 0; j < stringArray2.length; ++j) {
                    propertyDescriptorArray2 = stringArray2[j];
                    if (stringArray != null && !JdbcBeanUtil.isIn((String)propertyDescriptorArray2, stringArray)) continue;
                    this.append(jdbcBeanInterface.getJdbcTable() + "." + (String)propertyDescriptorArray2, " = ", this.bean.getJdbcTable() + "." + (String)propertyDescriptorArray2, "AND", stringBuffer);
                }
                BeanInfo beanInfo = null;
                propertyDescriptorArray2 = null;
                beanInfo = Introspector.getBeanInfo(jdbcBeanInterface.getClass());
                propertyDescriptorArray2 = beanInfo.getPropertyDescriptors();
                for (int j = 0; j < propertyDescriptorArray2.length; ++j) {
                    String[] stringArray3;
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[j];
                    if (propertyDescriptor.isHidden()) continue;
                    String string = propertyDescriptor.getName();
                    if (stringArray != null && !JdbcBeanUtil.isIn(string, stringArray) || (stringArray3 = this.getSQLOperatorNValue(jdbcBeanInterface, propertyDescriptor)) == null) continue;
                    this.append(jdbcBeanInterface.getJdbcTable() + "." + string, stringArray3[0], stringArray3[1], "AND", stringBuffer);
                }
                vector.addElement(jdbcBeanInterface);
                jdbcBeanInterface.getSerializer().appendForeignKeys(vector, stringBuffer, stringArray);
            }
        }
    }

    protected String computeSQLCount(boolean bl, boolean bl2, String[] stringArray) {
        String string = bl2 ? "DISTINCT count(*)" : "count(*)";
        return this.computeSQLSelect(bl, string, stringArray);
    }

    private String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl) {
        return this.computeSQLSelect(stringArray, blArray, bl, "*", null);
    }

    private String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl, String string) {
        return this.computeSQLSelect(stringArray, blArray, bl, string, null);
    }

    protected String computeSQLSelect(String[] stringArray, boolean[] blArray, boolean bl, String string, String[] stringArray2) {
        String string2 = this.computeSQLSelect(bl, string, stringArray2);
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (stringArray != null) {
            stringBuffer.append(" ORDER BY ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
                if (blArray[i]) continue;
                stringBuffer.append(" DESC");
            }
        }
        return stringBuffer.toString();
    }

    private String computeSQLSelect(boolean bl, String string, String[] stringArray) {
        try {
            int n;
            Object object;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = this.bean.getJdbcTable();
            this.beantables = new Vector();
            this.beantables.addElement(this.bean);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (bl) {
                this.appendForeignKeys(this.beantables, stringBuffer, propertyDescriptorArray, stringArray);
            }
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                String[] stringArray2;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden()) continue;
                object = propertyDescriptor.getName();
                if (stringArray != null && !JdbcBeanUtil.isIn((String)object, stringArray) || (stringArray2 = this.getSQLOperatorNValue(this.bean, propertyDescriptor)) == null) continue;
                this.append(string2 + "." + (String)object, stringArray2[0], stringArray2[1], "AND", stringBuffer);
            }
            if (stringBuffer.length() > 0) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < this.beantables.size(); ++i) {
                    object = (JdbcBeanInterface)this.beantables.elementAt(i);
                    if (i != 0) {
                        stringBuffer2.append(", ");
                    }
                    stringBuffer2.append(object.getJdbcTable());
                }
                stringBuffer2.append(" WHERE ");
                stringBuffer2.insert(0, "SELECT " + string + " FROM ");
                stringBuffer2.append(stringBuffer.toString());
                stringBuffer = stringBuffer2;
            } else {
                stringBuffer = new StringBuffer("SELECT " + string + " FROM ");
                stringBuffer.append(string2);
            }
            block9: for (int i = 0; i < this.priority.length && (n = this.priority[i]) != -1; ++i) {
                switch (n) {
                    case 10: {
                        if (this.intersect_serializer == null) continue block9;
                        object = this.intersect_serializer.computeSQLSelect(bl, string, stringArray);
                        stringBuffer.append(" INTERSECT (").append((String)object);
                        stringBuffer.append(")");
                        continue block9;
                    }
                    case 20: {
                        if (this.union_serializer == null) continue block9;
                        object = this.union_serializer.computeSQLSelect(bl, string, stringArray);
                        stringBuffer.append(" UNION (").append((String)object);
                        stringBuffer.append(")");
                        continue block9;
                    }
                    case 30: {
                        if (this.except_serializer == null) continue block9;
                        object = this.except_serializer.computeSQLSelect(bl, string, stringArray);
                        stringBuffer.append(" EXCEPT (").append((String)object);
                        stringBuffer.append(")");
                        continue block9;
                    }
                }
            }
            return stringBuffer.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String computeSQLInsert() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                String string;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden() || (string = this.getSQLValue(this.bean, propertyDescriptor)) == null) continue;
                this.appendInsert(propertyDescriptor.getName(), string, stringBuffer, stringBuffer2);
            }
            if (stringBuffer.length() > 0) {
                StringBuffer stringBuffer3 = new StringBuffer("INSERT INTO ");
                stringBuffer3.append(this.bean.getJdbcTable()).append(" ");
                stringBuffer3.append(stringBuffer).append(") ");
                stringBuffer3.append("VALUES ").append(stringBuffer2).append(")");
                return stringBuffer3.toString();
            }
            return null;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String computeSQLDelete() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer(this.bean.getJdbcTable());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                String[] stringArray;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden() || (stringArray = this.getSQLOperatorNValue(this.bean, propertyDescriptor)) == null) continue;
                this.append(propertyDescriptor.getName(), stringArray[0], stringArray[1], "AND", stringBuffer);
            }
            if (stringBuffer.length() <= 0) {
                return null;
            }
            stringBuffer2.append(" WHERE ");
            stringBuffer2.insert(0, "DELETE FROM ");
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer = stringBuffer2;
            return stringBuffer.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected String computeSQLUpdate(String[] stringArray) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer(this.bean.getJdbcTable());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden()) continue;
                String string = propertyDescriptor.getName();
                String[] stringArray2 = this.getSQLOperatorNValue(this.bean, propertyDescriptor);
                if (stringArray2 == null) continue;
                if (JdbcBeanUtil.isIn(string, stringArray)) {
                    this.append(string, stringArray2[0], stringArray2[1], "AND", stringBuffer2);
                    continue;
                }
                this.append(string, stringArray2[0], stringArray2[1], ",", stringBuffer);
            }
            if (stringBuffer.length() <= 0) {
                return null;
            }
            stringBuffer3.append(" SET ");
            stringBuffer3.insert(0, "UPDATE ");
            stringBuffer3.append(stringBuffer.toString());
            stringBuffer3.append(" WHERE ");
            stringBuffer3.append(stringBuffer2.toString());
            stringBuffer = stringBuffer3;
            return stringBuffer.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected JdbcServer getJdbcServer() {
        Properties properties = new Properties();
        Jdbc.setMaxConn(properties, this.bean.getMaxConn());
        return JdbcServer.getServer(this.bean.getJdbcURI(), this.bean.getJdbcUser(), this.bean.getJdbcPassword(), this.bean.getJdbcDriver(), properties);
    }

    private void executeSQLQuery(String string) throws SQLException {
        this.result = this.getJdbcServer().runQuery(string, false);
    }

    private int executeSQLUpdate(String string) throws SQLException {
        return this.getJdbcServer().runUpdate(string, false);
    }

    public int count() {
        return this.count(true, false, null);
    }

    public int count(String[] stringArray) {
        return this.count(true, false, stringArray);
    }

    public int count(boolean bl) {
        return this.count(bl, false, null);
    }

    public int count(boolean bl, boolean bl2) {
        return this.count(bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(boolean bl, boolean bl2, String[] stringArray) {
        String string = this.computeSQLCount(bl, bl2, stringArray);
        try {
            this.executeSQLQuery(string);
            if (this.result.first()) {
                int n = this.result.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            this.result = null;
            this.beantables = null;
        }
    }

    public void select() {
        boolean[] blArray = new boolean[]{true};
        this.select((String[])null, blArray, true, false);
    }

    public void select(boolean bl) {
        boolean[] blArray = new boolean[]{true};
        this.select((String[])null, blArray, bl, false);
    }

    public void select(String string) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{true};
        this.select(stringArray, blArray, true, false);
    }

    public void select(String string, boolean bl, boolean bl2) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{bl};
        this.select(stringArray, blArray, bl2, false);
    }

    public void select(String string, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = new String[]{string};
        boolean[] blArray = new boolean[]{bl};
        this.select(stringArray, blArray, bl2, bl3);
    }

    public void select(String[] stringArray) {
        boolean[] blArray = new boolean[]{true};
        this.select(stringArray, blArray, true, false);
    }

    public void select(String[] stringArray, boolean[] blArray, boolean bl, boolean bl2) {
        String string = bl2 ? "DISTINCT *" : "*";
        String string2 = this.computeSQLSelect(stringArray, blArray, bl, string);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    public void select(String[] stringArray, boolean[] blArray, boolean bl, boolean bl2, String[] stringArray2) {
        CharSequence charSequence;
        String string = null;
        if (stringArray2 != null) {
            charSequence = new StringBuffer();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i != 0) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append(stringArray2[i]).append(" ");
            }
            string = ((StringBuffer)charSequence).toString();
        } else {
            string = "*";
        }
        charSequence = bl2 ? "DISTINCT " + string : string;
        String string2 = this.computeSQLSelect(stringArray, blArray, bl, (String)charSequence);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    public void selectDistinct(String string) {
        boolean[] blArray = new boolean[]{true};
        String[] stringArray = new String[]{string};
        String string2 = this.computeSQLSelect(stringArray, blArray, false, "DISTINCT " + string);
        try {
            this.executeSQLQuery(string2);
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
        }
    }

    private void setPriority(int n) {
        for (int i = 0; i < this.priority.length && this.priority[i] != -1; ++i) {
            if (this.priority[i] != n) continue;
            return;
        }
        this.priority[i] = n;
    }

    public JdbcBeanSerializer intersect(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(10);
        this.intersect_serializer = jdbcBeanInterface.getSerializer();
        return this.intersect_serializer;
    }

    public JdbcBeanSerializer union(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(20);
        this.union_serializer = jdbcBeanInterface.getSerializer();
        return this.union_serializer;
    }

    public JdbcBeanSerializer except(JdbcBeanInterface jdbcBeanInterface) {
        this.setPriority(30);
        this.except_serializer = jdbcBeanInterface.getSerializer();
        return this.except_serializer;
    }

    public void removeIntersectBean() {
        this.intersect_serializer = null;
    }

    public void removeUnionBean() {
        this.union_serializer = null;
    }

    public void removeExceptBean() {
        this.except_serializer = null;
    }

    public boolean insert() {
        if (!this.isModified()) {
            return false;
        }
        JdbcBeanInterface[] jdbcBeanInterfaceArray = this.getJdbcBeans();
        for (int i = 0; i < jdbcBeanInterfaceArray.length; ++i) {
            JdbcBeanInterface jdbcBeanInterface = jdbcBeanInterfaceArray[i];
            JdbcBeanSerializer jdbcBeanSerializer = jdbcBeanInterface.getSerializer();
            if (!jdbcBeanSerializer.isModified()) continue;
            jdbcBeanSerializer.insert();
            this.updateForeignKeys(jdbcBeanInterface);
        }
        if (!this.bean.getReadOnly()) {
            String string = this.computeSQLInsert();
            try {
                this.executeSQLUpdate(string);
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
                return false;
            }
        }
        this.select(false);
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.first()) {
                return this.updateProperties(false);
            }
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public boolean update(String string) {
        String[] stringArray = new String[]{string};
        return this.update(stringArray);
    }

    public boolean update(String[] stringArray) {
        if (!this.isModified()) {
            return false;
        }
        String string = this.computeSQLUpdate(stringArray);
        try {
            int n = this.executeSQLUpdate(string);
            return n > 0;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public boolean delete() {
        if (this.bean.getReadOnly()) {
            return false;
        }
        String string = this.computeSQLDelete();
        try {
            int n = this.executeSQLUpdate(string);
            return n > 0;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL STATE: " + sQLException.getSQLState());
            sQLException.printStackTrace();
            this.result = null;
            return false;
        }
    }

    public boolean first() {
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.first()) {
                return this.updateProperties();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public boolean next() {
        try {
            if (this.result == null) {
                return false;
            }
            if (this.result.next()) {
                return this.updateProperties();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public boolean isLast() {
        try {
            if (this.result == null) {
                return true;
            }
            return this.result.isLast();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public void clean() {
        this.result = null;
        PropertyCache.removeProperties(this.bean);
        this.markModified(false);
    }

    public void initBean() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden() || JdbcBeanUtil.isJdbcBean(propertyDescriptor.getPropertyType())) continue;
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Object object = null;
                if (method == null || method2 == null) continue;
                try {
                    object = method.invoke((Object)this.bean.getDefault(), (Object[])null);
                    Object[] objectArray = new Object[]{object};
                    method2.invoke((Object)this.bean, objectArray);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
            this.clean();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private int findColumn(Vector vector, ResultSet resultSet, String string) throws SQLException {
        String string2 = this.bean.getJdbcTable();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        boolean bl = false;
        if (resultSetMetaData.getTableName(1).length() > 0) {
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                String string3 = resultSetMetaData.getTableName(i);
                if (!resultSetMetaData.getTableName(i).equalsIgnoreCase(string2) || !resultSetMetaData.getColumnName(i).equalsIgnoreCase(string)) continue;
                return i;
            }
        } else {
            Vector<Integer> vector2 = new Vector<Integer>();
            try {
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    if (!resultSetMetaData.getColumnName(i).equals(string)) continue;
                    vector2.addElement(new Integer(i));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (vector2.size() == 0) {
                return -1;
            }
            if (vector2.size() == 1) {
                return (Integer)vector2.elementAt(0);
            }
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                JdbcBeanInterface jdbcBeanInterface = (JdbcBeanInterface)vector.elementAt(i);
                if (jdbcBeanInterface == this.bean) {
                    return (Integer)vector2.elementAt(n);
                }
                if (jdbcBeanInterface.getSerializer().getPropertyDescriptor(string) == null) continue;
                ++n;
            }
        }
        return -1;
    }

    private boolean updateProperties() {
        return this.updateProperties(this.beantables, this.result, true);
    }

    private boolean updateProperties(boolean bl) {
        return this.updateProperties(this.beantables, this.result, bl);
    }

    private boolean updateProperties(Vector vector, ResultSet resultSet) {
        return this.updateProperties(vector, resultSet, true);
    }

    private boolean updateProperties(Vector vector, ResultSet resultSet, boolean bl) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden()) continue;
                try {
                    Method method;
                    Object[] objectArray;
                    int n = this.findColumn(vector, resultSet, propertyDescriptor.getName());
                    if (n == -1) continue;
                    Object object = resultSet.getObject(n);
                    Class<?> clazz = propertyDescriptor.getPropertyType();
                    object = SQL.getMatchingValue(clazz, object);
                    if (object != null) {
                        objectArray = new Object[]{object};
                        method = propertyDescriptor.getWriteMethod();
                        if (method == null) continue;
                        try {
                            method.invoke((Object)this.bean, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                        continue;
                    }
                    objectArray = propertyDescriptor.getReadMethod();
                    method = propertyDescriptor.getWriteMethod();
                    if (objectArray == null || method == null) continue;
                    try {
                        object = objectArray.invoke((Object)this.bean.getDefault(), (Object[])null);
                        Object[] objectArray2 = new Object[]{object};
                        method.invoke((Object)this.bean, objectArray2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (bl) {
                JdbcBeanInterface[] jdbcBeanInterfaceArray = this.getJdbcBeans();
                for (int i = 0; i < jdbcBeanInterfaceArray.length; ++i) {
                    jdbcBeanInterfaceArray[i].getSerializer().updateProperties(vector, resultSet);
                }
            }
            this.markModified(false);
            return true;
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
    }

    public void updateProperties(JdbcBeanInterface jdbcBeanInterface) {
        if (jdbcBeanInterface.getClass() != this.bean.getClass()) {
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.isHidden()) continue;
                try {
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    Object object = method.invoke((Object)jdbcBeanInterface, (Object[])null);
                    if (object == null) continue;
                    Object[] objectArray = new Object[]{object};
                    method2.invoke((Object)this.bean, objectArray);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (!propertyDescriptor.getName().equals(string)) continue;
                return propertyDescriptor;
            }
            return null;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    private void updateForeignKeys(JdbcBeanInterface jdbcBeanInterface) {
        String[] stringArray = this.getForeignKeys(jdbcBeanInterface.getClass(), this.bean.getClass());
        JdbcBeanSerializer jdbcBeanSerializer = jdbcBeanInterface.getSerializer();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i];
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                PropertyDescriptor propertyDescriptor2 = jdbcBeanSerializer.getPropertyDescriptor(string);
                Method method = propertyDescriptor2.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                Object object = method.invoke((Object)jdbcBeanInterface, (Object[])null);
                if (object == null) continue;
                Object[] objectArray = new Object[]{object};
                method2.invoke((Object)this.bean, objectArray);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        PropertyCache.removeProperties(this.bean);
    }

    public JdbcBeanSerializer(JdbcBeanInterface jdbcBeanInterface) {
        this.bean = jdbcBeanInterface;
        jdbcBeanInterface.addPropertyChangeListener(this);
    }
}

