/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSFlipConjunctionIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        return this.getText(BinaryOperatorUtils.getOperatorText(sign));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention", "getElementPredicate"));
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSBinaryExpression binaryExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention", "processIntention"));
        }
        JSBinaryExpression exp = binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        JSElement parent = (JSElement)exp.getParent();
        while (JSFlipConjunctionIntention.isConjunctionExpression(parent, sign)) {
            exp = (JSExpression)parent;
            assert (exp != null);
            parent = (JSElement)exp.getParent();
        }
        JSElementFactory.replaceExpression((JSExpression)exp, this.flipExpression((JSExpression)exp, sign));
    }

    private String flipExpression(JSExpression exp, IElementType conjunctionType) {
        if (JSFlipConjunctionIntention.isConjunctionExpression((JSElement)exp, conjunctionType)) {
            JSBinaryExpression andExpression = (JSBinaryExpression)exp;
            return this.flipExpression(andExpression.getROperand(), conjunctionType) + ' ' + BinaryOperatorUtils.getOperatorText(conjunctionType) + ' ' + this.flipExpression(andExpression.getLOperand(), conjunctionType);
        }
        return exp.getText();
    }

    private static boolean isConjunctionExpression(JSElement expression, IElementType conjunctionType) {
        if (!(expression instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
        return binaryExpression.getOperationSign().equals(conjunctionType);
    }
}

