/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.JSVariablesWithInitializerPredicate;
import org.intellij.idea.lang.javascript.intention.initialization.TypeScriptVariableOrFieldPredicate;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSpecifyTypeExplicitlyIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new TypeScriptVariableOrFieldPredicate(){

        @Override
        protected boolean checkVariableOrField(@NotNull JSInitializerOwner initializerOwner) {
            if (initializerOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializerOwner", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention$1", "checkVariableOrField"));
            }
            return TypeScriptSpecifyTypeExplicitlyIntention.check(initializerOwner);
        }
    };

    private static boolean check(@NotNull JSInitializerOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "check"));
        }
        return ((JSTypeDeclarationOwner)element).getTypeElement() == null && element.hasInitializer();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "processIntention"));
        }
        if (!(element instanceof TypeScriptVariable) && !(element instanceof JSField)) {
            return;
        }
        JSInitializerOwner initializerOwner = (JSInitializerOwner)element;
        if (!TypeScriptSpecifyTypeExplicitlyIntention.check(initializerOwner)) {
            return;
        }
        PsiFile containingFile = initializerOwner.getContainingFile();
        String newTypeDeclaration = JSVariablesWithInitializerPredicate.getTypeString(containingFile, initializerOwner);
        if (StringUtil.isEmptyOrSpaces((String)newTypeDeclaration)) {
            return;
        }
        PsiElement newVarStatement = TypeScriptSpecifyTypeExplicitlyIntention.createNewVarStatement(initializerOwner, containingFile, newTypeDeclaration);
        if (newVarStatement == null) {
            return;
        }
        JSInitializerOwner newInitializerOwner = (JSInitializerOwner)PsiTreeUtil.getChildOfType((PsiElement)newVarStatement, JSInitializerOwner.class);
        if (newInitializerOwner == null) {
            return;
        }
        initializerOwner.replace((PsiElement)newInitializerOwner);
        JSElementFactory.reformat((PsiElement)newInitializerOwner);
    }

    private static PsiElement createNewVarStatement(@NotNull JSInitializerOwner element, @NotNull PsiFile containingFile, @NotNull String newTypeDeclaration) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "createNewVarStatement"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "createNewVarStatement"));
        }
        if (newTypeDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeDeclaration", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "createNewVarStatement"));
        }
        boolean isField = element instanceof JSField;
        StringBuilder declarationBuffer = new StringBuilder();
        if (!isField) {
            declarationBuffer.append("var ");
        }
        declarationBuffer.append(element.getName());
        declarationBuffer.append(":");
        declarationBuffer.append(newTypeDeclaration);
        JSExpression initializer = element.getInitializer();
        if (initializer != null) {
            declarationBuffer.append("=");
            declarationBuffer.append(initializer.getText());
        }
        if (isField) {
            return TypeScriptChangeUtil.createClassMemberFromText((Project)element.getProject(), (String)declarationBuffer.toString(), (DialectOptionHolder)DialectDetector.dialectOfElement((PsiElement)element));
        }
        return JSChangeUtil.createStatementFromTextWithContext((Project)containingFile.getProject(), (String)declarationBuffer.toString(), (PsiElement)element).getPsi();
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptSpecifyTypeExplicitlyIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

