/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Map;
import java.util.WeakHashMap;
import org.gradle.api.Nullable;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderHasher;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.MultiParentClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableClassLoaderHierarchyHasher
implements ClassLoaderHierarchyHasher {
    private static final byte[] UNKNOWN = "unknown".getBytes(Charsets.UTF_8);
    private final Map<ClassLoader, byte[]> knownClassLoaders;
    private final ClassLoaderHasher classLoaderHasher;

    public ConfigurableClassLoaderHierarchyHasher(Map<ClassLoader, String> knownClassLoaders, ClassLoaderHasher classLoaderHasher) {
        this.classLoaderHasher = classLoaderHasher;
        WeakHashMap<ClassLoader, byte[]> hashes = new WeakHashMap<ClassLoader, byte[]>();
        for (Map.Entry<ClassLoader, String> entry : knownClassLoaders.entrySet()) {
            hashes.put(entry.getKey(), entry.getValue().getBytes(Charsets.UTF_8));
        }
        this.knownClassLoaders = hashes;
    }

    @Override
    public HashCode getLenientHash(ClassLoader classLoader) {
        Visitor visitor = new Visitor();
        visitor.visit(classLoader);
        return visitor.getHash();
    }

    @Override
    @Nullable
    public HashCode getStrictHash(ClassLoader classLoader) {
        Visitor visitor = new Visitor();
        visitor.visit(classLoader);
        return visitor.hasUnknown() ? null : visitor.getHash();
    }

    private class Visitor
    extends ClassLoaderVisitor {
        private final Hasher hasher = Hashing.md5().newHasher();
        private boolean foundUnknown;

        private Visitor() {
        }

        public void visit(ClassLoader classLoader) {
            if (this.addToHash(classLoader)) {
                super.visit(classLoader);
            }
        }

        public HashCode getHash() {
            return this.hasher.hash();
        }

        public boolean hasUnknown() {
            return this.foundUnknown;
        }

        private boolean addToHash(ClassLoader cl) {
            byte[] knownId = (byte[])ConfigurableClassLoaderHierarchyHasher.this.knownClassLoaders.get(cl);
            if (knownId != null) {
                this.hasher.putBytes(knownId);
                return false;
            }
            if (cl instanceof CachingClassLoader || cl instanceof MultiParentClassLoader) {
                return true;
            }
            HashCode hash = ConfigurableClassLoaderHierarchyHasher.this.classLoaderHasher.getHash(cl);
            if (hash != null) {
                this.hasher.putBytes(hash.asBytes());
                return true;
            }
            this.hasher.putBytes(UNKNOWN);
            this.foundUnknown = true;
            return true;
        }
    }
}

