/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiInjectInspection
extends CdiBaseInspection {
    @Override
    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        CdiInjectInspection.checkInjectedConstructor(descriptor, holder);
        CdiInjectInspection.checkInjectedMethods(descriptor, holder);
        CdiInjectInspection.checkInjectedFields(descriptor, holder);
    }

    private static void checkInjectedMethods(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = descriptor.getInjectedMethods();
        for (PsiMethod method : methods) {
            CdiInjectInspection.checkNonStatic(method, holder);
            CdiInjectInspection.checkNonAbstract(method, holder);
            CdiInjectInspection.checkWrongAnnotations(method, holder);
            CdiInjectInspection.checkWrongAnnotatedParameters(method, holder);
        }
    }

    private static void checkWrongAnnotatedParameters(PsiMethod method, ProblemsHolder holder) {
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            CdiInjectInspection.checkWrongAnnotatedParameter(method, holder, "javax.enterprise.inject.Disposes", parameter);
            CdiInjectInspection.checkWrongAnnotatedParameter(method, holder, "javax.enterprise.event.Observes", parameter);
        }
    }

    private static void checkWrongAnnotatedParameter(PsiMethod method, ProblemsHolder holder, String anno, PsiParameter parameter) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)anno, (boolean)true)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.injected.with.disposes.parameters", anno), new LocalQuickFix[0]);
        }
    }

    private static void checkNonStatic(PsiMethod method, ProblemsHolder holder) {
        if (method.getModifierList().hasModifierProperty("static")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.injected.method.cannot.be.static", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkNonAbstract(PsiMethod method, ProblemsHolder holder) {
        if (method.getModifierList().hasModifierProperty("abstract")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.injected.method.cannot.be.abstract", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkWrongAnnotations(PsiMethod method, ProblemsHolder holder) {
        CdiInjectInspection.checkWrongAnnotation(method, "javax.enterprise.inject.Produces", holder);
    }

    private static void checkWrongAnnotation(PsiMethod method, String annotation, ProblemsHolder holder) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotation, (boolean)true)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.wrong.injected.method.annotation", annotation), new LocalQuickFix[0]);
        }
    }

    private static void checkInjectedConstructor(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = descriptor.getInjectedConstructors();
        if (methods.size() > 1) {
            for (PsiMethod method : methods) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"javax.inject.Inject"});
                assert (annotation != null);
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiInjectInspection.more.than.one.injected.constructor", methods.size()), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkInjectedFields(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiField> injectedFields = descriptor.getInjectedFields();
        for (PsiField field : injectedFields) {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) continue;
            if (modifierList.hasModifierProperty("static")) {
                holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectionInspection.field.cannot.be.static", new Object[0]), new LocalQuickFix[0]);
            }
            if (modifierList.hasModifierProperty("final")) {
                holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectionInspection.field.cannot.be.final", new Object[0]), new LocalQuickFix[0]);
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)"javax.enterprise.inject.Produces", (boolean)true)) continue;
            holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiInjectInspection.field.cannot.be.annotated.produces", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.injected.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiInjectInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectInspection", "getShortName"));
        }
        return "CdiInjectInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

