/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiNormalScopeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiNormalScopeInspection", "checkClass"));
        }
        CdiNormalScopeInspection.checkPublicFields(psiClass, holder, module);
    }

    private static void checkPublicFields(PsiClass psiClass, ProblemsHolder holder, Module module) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, CdiCommonUtils.getNormalScopeQualifiedNames(module));
        if (annotation != null) {
            for (PsiField field : psiClass.getFields()) {
                PsiModifierList modifierList = field.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("public") || modifierList.hasModifierProperty("static")) continue;
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiNormalScopeInspection.public.field.in.normal.scoped.beans", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.bean.normal.scope.inconsystency", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiNormalScopeInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiNormalScopeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiNormalScopeInspection", "getShortName"));
        }
        return "CdiNormalScopeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiNormalScopeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

