/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.javascript.debugger.ChromeEvaluator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.jetbrains.javascript.debugger.MemberFilterVisitor;
import com.jetbrains.javascript.debugger.NavigatableVariable;
import com.jetbrains.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.jetbrains.javascript.debugger.scripts.ScriptsKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J0\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J>\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0+H\u0014J$\u0010,\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020/H\u0016J2\u00100\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J$\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0013J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J,\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010#2\u0006\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0016J,\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010#2\u0006\u00109\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0016J\u001c\u0010=\u001a\u0004\u0018\u00010>2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020.H\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020>2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010I\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010J\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010K\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010L\u001a\u0004\u0018\u00010#H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R;\u0010\u0007\u001a/\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006M"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/debugger/Scope;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "Lorg/jetbrains/annotations/NotNull;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "canNavigateToSource", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeReceiverVariable", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createFrameEvaluator", "Lcom/jetbrains/javascript/debugger/ChromeEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "tryToResolveByUrl", "getMemberFilter", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "functionName", "scriptUrl", "line", "", "column", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "isInLibraryContent", "sourceInfo", "isMemberVisible", "rawNameToSource", "transformErrorOnGetUsedReferenceValue", "error", "JavaScriptDebugger"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    private final ConcurrentMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public Vm getVm() {
        return this.debugProcess.getMainVm();
    }

    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile(script, sourceInfo);
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL) ^ true || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result = (Promise<MemberFilter>)this.scopeToMemberFilter.get(scope);
        if (result != null) {
            return result;
        }
        result = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, (Promise<MemberFilter>)this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise = this.scopeToMemberFilter.putIfAbsent(scope, result);
        if (promise == null) {
            promise = result;
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        void status;
        block15: {
            void document;
            PsiElement it;
            PsiElement psiElement;
            CharSequence charSequence;
            ValueType valueType;
            Value value;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            Value value2 = value = variable.getValue();
            Object object = valueType = value2 != null ? value2.getType() : null;
            if (Intrinsics.areEqual((Object)valueType, (Object)ValueType.FUNCTION)) {
                return ThreeState.NO;
            }
            if (value instanceof ObjectValue) {
                charSequence = ((ObjectValue)value).getClassName();
                if (charSequence == null || charSequence.length() == 0) {
                    charSequence = value.getValueString();
                    if ((charSequence == null || charSequence.length() == 0) && JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow().isEmpty()) {
                        return ThreeState.NO;
                    }
                }
            }
            if (!(variable instanceof NavigatableVariable)) {
                JSVariable jSVariable = this.getVariable(name, context);
                if (jSVariable != null) {
                    charSequence = jSVariable;
                    JSVariable it2 = (JSVariable)charSequence;
                    PsiElement navigationElement = it2.getNavigationElement();
                    VirtualFile file = navigationElement.getContainingFile().getVirtualFile();
                    VirtualFile virtualFile = file;
                    if (virtualFile != null) {
                        VirtualFile virtualFile2 = virtualFile;
                        VirtualFile it3 = virtualFile2;
                        virtualFile = FileDocumentManager.getInstance().getDocument(it3);
                        if (virtualFile != null) {
                            virtualFile2 = virtualFile;
                            it3 = (Document)virtualFile2;
                            callback.computed(XDebuggerUtil.getInstance().createPositionByOffset(file, navigationElement.getTextOffset()));
                            return ThreeState.YES;
                        }
                    }
                }
                return ThreeState.NO;
            }
            Variable variable2 = variable;
            if (variable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.javascript.debugger.NavigatableVariableBackedPsiElement");
            }
            NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)variable2;
            Ref.ObjectRef it2 = new Ref.ObjectRef();
            it2.element = ThreeState.NO;
            PsiElement psiElement2 = navigatableVariable.getUnresolvedReferences();
            if (psiElement2 != null) {
                psiElement = psiElement2;
                it = psiElement;
                for (SmartPsiElementPointer<JSReferenceExpression> ref : it) {
                    Segment psiRange = ref.getPsiRange();
                    if (psiRange == null) continue;
                    callback.computed(XDebuggerUtil.getInstance().createPositionByOffset(ref.getVirtualFile(), psiRange.getStartOffset()));
                    status.element = ThreeState.YES;
                }
            }
            PsiElement psiElement3 = navigatableVariable.getElementPointer().getElement();
            if (psiElement3 == null) break block15;
            psiElement = psiElement3;
            it = psiElement;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            VirtualFile virtualFile = navigatableVariable.getElementPointer().getVirtualFile();
            Collection usages = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(it, virtualFile, (Ref.ObjectRef)document, navigatableVariable, callback, (Ref.ObjectRef)status){
                final /* synthetic */ PsiElement $it$inlined;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                final /* synthetic */ Ref.ObjectRef $document$inlined;
                final /* synthetic */ NavigatableVariableBackedPsiElement $navigatableVariable$inlined;
                final /* synthetic */ XInlineDebuggerDataCallback $callback$inlined;
                final /* synthetic */ Ref.ObjectRef $status$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final T compute() {
                    Collection collection;
                    PsiElement targetElement;
                    PsiElement psiElement = targetElement = this.$it$inlined instanceof PsiPolyVariantReference ? JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)((PsiPolyVariantReference)this.$it$inlined)) : this.$it$inlined;
                    if (targetElement == null) {
                        this.$callback$inlined.computed(XDebuggerUtil.getInstance().createPositionByElement(this.$it$inlined));
                        this.$status$inlined.element = ThreeState.YES;
                        collection = null;
                    } else {
                        Collection usages;
                        Collection collection2 = usages = IdentifierHighlighterPass.getUsages((PsiElement)targetElement, (PsiElement)((PsiElement)this.$it$inlined.getContainingFile()), (boolean)true);
                        if (!collection2.isEmpty()) {
                            Document dd = FileDocumentManager.getInstance().getDocument(this.$virtualFile$inlined);
                            if (dd == null) {
                                collection = null;
                            } else {
                                this.$document$inlined.element = dd;
                                collection = usages;
                            }
                        } else {
                            void var2_2;
                            collection = var2_2;
                        }
                    }
                    return (T)collection;
                }
                {
                    this.$it$inlined = psiElement;
                    this.$virtualFile$inlined = virtualFile;
                    this.$document$inlined = objectRef;
                    this.$navigatableVariable$inlined = navigatableVariableBackedPsiElement;
                    this.$callback$inlined = xInlineDebuggerDataCallback;
                    this.$status$inlined = objectRef2;
                }
            });
            if (usages != null) {
                for (TextRange usage : usages) {
                    int offset = usage.getStartOffset();
                    Document document2 = (Document)document.element;
                    if (document2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (offset > document2.getTextLength()) continue;
                    VirtualFile virtualFile3 = virtualFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                    Document document3 = (Document)document.element;
                    if (document3 == null) {
                        Intrinsics.throwNpe();
                    }
                    callback.computed((XSourcePosition)new SourceInfo(virtualFile3, document3.getLineNumber(offset), 0, offset, null, null, 52, null));
                }
                return ThreeState.YES;
            }
            objectRef = null;
            ThreeState cfr_ignored_1 = (ThreeState)status.element;
        }
        return (ThreeState)status.element;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script script3 = script2;
            Script it = script3;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            Vm vm2 = vm;
            Script it = (Script)vm2;
            sourceInfo = this.getSourceInfo(functionName, it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        if (Intrinsics.areEqual((Object)value.getType(), (Object)ValueType.NODE)) {
            String string = value.getValueString();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string = this.$string;
                        int n = 0;
                        XValuePresentation.XValueTextRenderer xValueTextRenderer = renderer;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string4 = string3;
                        xValueTextRenderer.renderComment(string4);
                        string = this.$string;
                        xValueTextRenderer = renderer;
                        String string5 = string;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                        string4 = string6;
                        xValueTextRenderer.renderValue(string4, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
                {
                    this.$string = $captured_local_variable$0;
                }
            }, true);
            return;
        }
        if (!Comparing.strEqual((String)value.getClassName(), (String)value.getValueString())) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List propertiesToShow = JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow();
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, propertiesToShow)) {
            return;
        }
        if (propertiesToShow.isEmpty() || Intrinsics.areEqual((Object)value.hasProperties(), (Object)ThreeState.NO)) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        Promise promise = value.getProperties(propertiesToShow, context.getEvaluateContext(), (Obsolescent)node);
        Promise promise2 = $receiver$iv.done((Consumer)new ObsolescentConsumer<List<? extends Variable>>((Obsolescent)node, (Obsolescent)node, node, value, icon){
            final /* synthetic */ Obsolescent $node;
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void consume(Object param) {
                List it = (List)param;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
            {
                this.$node = $captured_local_variable$1;
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super($super_call_param$2);
            }
        });
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        promise2.rejected((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkParameterIsNotNull((Object)objectValue, (String)"objectValue");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return new ChromeEvaluator((VariableContext)frame);
    }

    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)"TypeError", (Object)((ObjectValue)value).getClassName()) || Intrinsics.areEqual((Object)"ReferenceError", (Object)((ObjectValue)value).getClassName())) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return ((NavigatableVariable)variable).hasSourcePosition();
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL) && !Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.CLOSURE)) {
            if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.CATCH)) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        if (variable instanceof NavigatableVariable) {
            navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
            return;
        }
        JSVariable sourceVar = this.getVariable(name, context);
        if (sourceVar != null) {
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)sourceVar)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        void varRef;
        CallFrameView callFrameView;
        VariableContext variableContext = context.getParent();
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        if ((callFrameView = (CallFrameView)variableContext) == null || (callFrameView = callFrameView.getSourcePosition()) == null) {
            return null;
        }
        CallFrameView sourcePosition2 = callFrameView;
        VirtualFile virtualFile = sourcePosition2.getFile();
        int n = sourcePosition2.getOffset();
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        PsiElement psiElement = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement == null) {
            return null;
        }
        PsiElement contextElement = psiElement;
        JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        PsiElement psiElement2 = jSFunction != null ? (PsiElement)jSFunction : (PsiElement)contextElement.getContainingFile();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement host = psiElement2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        host.accept((PsiElementVisitor)new JSElementVisitor((Ref.ObjectRef)varRef, variableSourceName){
            final /* synthetic */ Ref.ObjectRef $varRef;
            final /* synthetic */ String $variableSourceName;

            public void visitJSElement(@NotNull JSElement node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if ((JSVariable)this.$varRef.element == null) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSParameter(@NotNull JSParameter node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$varRef.element = (JSVariable)node;
                } else {
                    super.visitJSParameter(node);
                }
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$varRef.element = node;
                } else {
                    super.visitJSVariable(node);
                }
            }
            {
                this.$varRef = $captured_local_variable$0;
                this.$variableSourceName = $captured_local_variable$1;
            }
        });
        return (JSVariable)varRef.element;
    }

    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return this.debugProcess.normalizeMemberName(string);
    }

    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Vm vm, @NotNull Script script, boolean tryToResolveByUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Promise<VirtualFile> promise = ScriptsKt.getCachedActualFile(script, vm);
        if (promise != null) {
            Promise<VirtualFile> promise2 = promise;
            Promise<VirtualFile> it = promise2;
            return it;
        }
        Url url = script.getUrl();
        if (tryToResolveByUrl && !StringsKt.endsWith$default((String)url.getPath(), (String)"!transpiled", (boolean)false, (int)2, null)) {
            Function1<VirtualFile, VirtualFile> checkFile$ = new Function1<VirtualFile, VirtualFile>(script){
                final /* synthetic */ Script $script;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final VirtualFile invoke(@NotNull VirtualFile $receiver) {
                    void var3_4;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    byte[] byArray = $receiver.contentsToByteArray();
                    int n = this.$script.getEndLine();
                    int count$iv = 0;
                    for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                        void element$iv = $receiver$iv[i];
                        void it = element$iv;
                        if (!(it == (byte)10)) continue;
                        ++count$iv;
                    }
                    void var10_8 = var3_4;
                    if (n > var10_8 + 2) {
                        return null;
                    }
                    return $receiver;
                }
                {
                    this.$script = script;
                    super(1);
                }
            };
            VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this.debugProcess, url, false, 2, null);
            if (virtualFile != null && (virtualFile = checkFile$.invoke(virtualFile)) != null) {
                VirtualFile virtualFile2 = virtualFile;
                VirtualFile it = virtualFile2;
                return Promises.resolvedPromise((Object)it);
            }
            if (url.isInLocalFileSystem()) {
                VirtualFile virtualFile3 = LocalFileSystem.getInstance().findFileByPath(url.getPath());
                if (virtualFile3 != null && (virtualFile3 = checkFile$.invoke(virtualFile3)) != null) {
                    VirtualFile virtualFile4 = virtualFile3;
                    VirtualFile it = virtualFile4;
                    return Promises.resolvedPromise((Object)it);
                }
            }
        }
        Promise promise3 = ScriptsKt.getResolvedFile(script, vm).done((Consumer)new Consumer<VirtualFile>(this, url){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ Url $url;

            public final void consume(VirtualFile it) {
                JavaScriptDebugProcess<?> javaScriptDebugProcess = this.this$0.getDebugProcess();
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                javaScriptDebugProcess.saveResolvedFile(this.$url, virtualFile);
            }
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$url = url;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"getResolvedFile(script, \u2026veResolvedFile(url, it) }");
        return promise3;
    }

    @NotNull
    public Promise<?> computeReceiverVariable(@NotNull VariableContext context, @NotNull CallFrame callFrame, @NotNull XCompositeNode node) {
        Promise p2;
        VirtualFile file;
        CallFrameView callFrameView;
        VariableContext parent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        for (parent = context; parent != null && !(parent instanceof CallFrameView); parent = parent.getParent()) {
        }
        VariableContext variableContext = parent;
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        VirtualFile virtualFile = (callFrameView = (CallFrameView)variableContext) != null && (callFrameView = callFrameView.getSourcePosition()) != null ? callFrameView.getFile() : (file = null);
        if (file != null && (p2 = (Promise)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Promise<? extends Object>>(this, file, callFrame, node, context){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ CallFrame $callFrame;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ VariableContext $context;

            @Nullable
            public final Promise<? extends Object> compute() {
                Project project = this.this$0.getDebugProcess().getSession().getProject();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.$file);
                if (psiFile != null) {
                    try {
                        PsiElement executionScope;
                        int offset;
                        PsiElement elementAtOffset;
                        Document document;
                        Document document2 = document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                        if (document2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if ((elementAtOffset = psiFile.findElementAt(offset = document2.getLineStartOffset(this.$callFrame.getLine()) + this.$callFrame.getColumn())) != null && (executionScope = JSPsiImplUtils.getExecutionScope((PsiElement)elementAtOffset)) instanceof JSFunction && JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunction)executionScope)) != null) {
                            Obsolescent node$iv;
                            Promise $receiver$iv;
                            Promise promise = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)this.$callFrame.getEvaluateContext(), (String)"this", null, (boolean)false, (int)6, null);
                            Obsolescent obsolescent = (Obsolescent)this.$node;
                            $receiver$iv = $receiver$iv.done((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, node$iv, this){
                                final /* synthetic */ Obsolescent $node;
                                final /* synthetic */ computeReceiverVariable.p.1 this$0;

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                public void consume(Object param) {
                                    EvaluateResult it = (EvaluateResult)param;
                                    this.this$0.$node.addChildren(XValueChildrenList.singleton((XNamedValue)((XNamedValue)VariableViewKt.VariableView((Variable)((Variable)new VariableImpl("this", it.getValue())), (VariableContext)this.this$0.$context))), true);
                                }
                                {
                                    this.$node = $captured_local_variable$1;
                                    this.this$0 = var3_3;
                                    super($super_call_param$2);
                                }
                            });
                            node$iv = (Obsolescent)this.$node;
                            return $receiver$iv.rejected((Consumer)new ObsolescentConsumer<Throwable>(node$iv, node$iv, this){
                                final /* synthetic */ Obsolescent $node;
                                final /* synthetic */ computeReceiverVariable.p.1 this$0;

                                public void consume(Throwable param) {
                                    Throwable it = param;
                                    this.this$0.$node.addChildren(XValueChildrenList.EMPTY, true);
                                }
                                {
                                    this.$node = $captured_local_variable$1;
                                    this.this$0 = var3_3;
                                    super($super_call_param$2);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$file = virtualFile;
                this.$callFrame = callFrame;
                this.$node = xCompositeNode;
                this.$context = variableContext;
            }
        })) != null) {
            return p2;
        }
        return super.computeReceiverVariable(context, callFrame, node);
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = ContainerUtil.newConcurrentMap();
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void resumed() {
                this.clear();
            }

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkParameterIsNotNull((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }
}

