/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.lib.tag.Tag;
import aQute.maven.api.Archive;
import aQute.maven.api.Revision;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class PomGenerator {
    private Revision name;
    private Revision parent;
    private boolean dependencyManagement;
    private Collection<Archive> dependencies;

    public PomGenerator(Collection<Archive> dependencies) {
        this.dependencies = dependencies;
    }

    public PomGenerator name(Revision name) {
        this.name = name;
        return this;
    }

    public PomGenerator parent(Revision name) {
        this.parent = name;
        return this;
    }

    public PomGenerator dependencyManagement(boolean value) {
        this.dependencyManagement = value;
        return this;
    }

    public void out(OutputStream out) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            PrintWriter pw = new PrintWriter(w);
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            Tag tag = this.build();
            tag.print(1, pw);
        }
    }

    public Tag build() {
        this.prune();
        Tag project = new Tag("project", new Object[0]);
        project.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.addAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        new Tag(project, "modelVersion", "4.0.0");
        if (this.parent != null) {
            Tag parent = new Tag(project, "parent", new Object[0]);
            this.gav(parent, this.parent);
        }
        this.gav(project, this.name);
        Tag depType = this.dependencyManagement ? new Tag(project, "dependencyManagement", new Object[0]) : project;
        Tag dependencies = new Tag(depType, "dependencies", new Object[0]);
        for (Archive dep : this.dependencies) {
            Tag dependency = new Tag(dependencies, "dependency", new Object[0]);
            this.gav(dependency, dep.revision);
            if (dep.hasClassifier()) {
                new Tag(dependency, "classifier", dep.classifier);
            }
            if (dep.hasExtension()) {
                new Tag(dependency, "type", dep.extension);
            }
            if (this.dependencyManagement) continue;
            new Tag(dependency, "scope", "runtime");
        }
        return project;
    }

    private void prune() {
        TreeSet<Archive> s = new TreeSet<Archive>(this.dependencies);
        Archive prev = null;
        Iterator<Archive> i = s.iterator();
        while (i.hasNext()) {
            boolean sameProgram;
            Archive a = i.next();
            boolean bl = sameProgram = prev != null && prev.revision.program.equals(a.revision.program);
            if (sameProgram) {
                System.out.println("Skipping " + a);
                i.remove();
                continue;
            }
            prev = a;
        }
        this.dependencies = s;
    }

    private void gav(Tag parent, Revision name) {
        new Tag(parent, "groupId", name.group);
        new Tag(parent, "artifactId", name.artifact);
        new Tag(parent, "version", name.version);
    }
}

