/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import org.jetbrains.idea.perforce.application.ListModification;
import org.jetbrains.idea.perforce.application.NumberNameModifier;

public class AddCommand
implements ListModification<AddCommand> {
    private final String myNewName;
    private final String myNewComment;
    private final Long myNumber;

    public AddCommand(String newName, String newComment, Long number) {
        this.myNewName = newName;
        this.myNewComment = newComment;
        this.myNumber = number;
    }

    @Override
    public void execute(Project project, ChangeListManagerGate gate, NumberNameModifier modifier) {
        modifier.add(this.myNewName);
        modifier.put(this.myNewName, this.myNumber);
        gate.findOrCreateList(this.myNewName, this.myNewComment);
    }

    @Override
    public boolean doesNothing() {
        return false;
    }

    public String getNewName() {
        return this.myNewName;
    }
}

