/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspDirectiveKind;
import org.jetbrains.plugins.grails.lang.gsp.psi.GspPsiElementFactory;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterHtmlElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspScriptletTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirective;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirectiveAttribute;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;

public class GspPsiElementFactoryImpl
extends GspPsiElementFactory {
    Project myProject;

    public GspPsiElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public GspDirective createDirectiveByKind(GspDirectiveKind kind) {
        return (GspDirective)this.createElementFromText("<%@ " + kind.toString().toLowerCase() + " %>");
    }

    @Override
    public GspDirectiveAttribute createDirectiveAttribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/lang/gsp/psi/GspPsiElementFactoryImpl", "createDirectiveAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/grails/lang/gsp/psi/GspPsiElementFactoryImpl", "createDirectiveAttribute"));
        }
        GspDirective gspDirective = (GspDirective)this.createElementFromText("<%@ page " + name + "=\"" + value + "\" %>");
        return (GspDirectiveAttribute)gspDirective.getAttribute(name);
    }

    @Override
    public GspScriptletTag createScriptletTagFromText(String s2) {
        return (GspScriptletTag)this.createElementFromText("<%" + s2 + "%>");
    }

    @Override
    public GspOuterHtmlElement createOuterHtmlElement(String text) {
        return (GspOuterHtmlElement)this.createElementFromText(text);
    }

    private GspFile createDummyFile(String s2) {
        return (GspFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("DUMMY__." + GspFileType.GSP_FILE_TYPE.getDefaultExtension(), s2);
    }

    @Override
    public <T> T createElementFromText(String text) {
        GspFile psiFile = this.createDummyFile(text);
        assert (psiFile instanceof GspFile);
        GspXmlRootTag rootTag = psiFile.getRootTag();
        assert (rootTag != null);
        return (T)rootTag.getFirstChild();
    }
}

