/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.constraints;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsConstraintsSharedReferenceProvider
implements GroovyNamedArgumentReferenceProvider {
    public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsSharedReferenceProvider", "createRef"));
        }
        if (namedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsSharedReferenceProvider", "createRef"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsSharedReferenceProvider", "createRef"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsSharedReferenceProvider", "createRef"));
        }
        return new PsiReference[]{new PsiReferenceBase<PsiElement>(element, false){

            private Map<String, PsiElement> getConstraintGroups(@Nullable String hint) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                if (module == null) {
                    return Collections.emptyMap();
                }
                VirtualFile conf = GrailsUtils.findConfDirectory(module);
                if (conf == null) {
                    return Collections.emptyMap();
                }
                VirtualFile configGroovy = conf.findChild("Config.groovy");
                if (configGroovy == null) {
                    return Collections.emptyMap();
                }
                PsiFile configGroovyPsi = this.getElement().getManager().findFile(configGroovy);
                if (!(configGroovyPsi instanceof GroovyFile)) {
                    return Collections.emptyMap();
                }
                HashMap<String, PsiElement> res = new HashMap<String, PsiElement>();
                for (PsiElement e = configGroovyPsi.getFirstChild(); e != null; e = e.getNextSibling()) {
                    GrExpression eClosure;
                    GrExpression lValue;
                    if (!(e instanceof GrAssignmentExpression) || !(lValue = ((GrAssignmentExpression)e).getLValue()).getText().equals("grails.gorm.default.constraints") || !((eClosure = ((GrAssignmentExpression)e).getRValue()) instanceof GrClosableBlock)) continue;
                    for (PsiElement m = eClosure.getFirstChild(); m != null; m = m.getNextSibling()) {
                        String methodName;
                        if (!(m instanceof GrMethodCall) || PsiImplUtil.hasExpressionArguments((GrArgumentList)((GrMethodCall)m).getArgumentList()) || (methodName = PsiUtil.getMethodName((GrMethodCall)((GrMethodCall)m))) == null || methodName.indexOf(42) != -1 || hint != null && !hint.equals(methodName)) continue;
                        res.put(methodName, m);
                        if (hint == null) continue;
                        return res;
                    }
                }
                return res;
            }

            public PsiElement resolve() {
                String value = this.getValue();
                Map<String, PsiElement> map2 = this.getConstraintGroups(value);
                return map2.get(value);
            }

            @NotNull
            public Object[] getVariants() {
                Set<String> strings = this.getConstraintGroups(null).keySet();
                Object[] objectArray = ArrayUtil.toObjectArray(strings);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintsSharedReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }
        }};
    }
}

