/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.paths.PathReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.WebAppFolderFileReferenceSet;
import org.jetbrains.plugins.grails.references.tagSupport.GspResourceDirAttributeSupport;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;

public class GspResourceContextPathAttributeSupport
extends TagAttributeReferenceProvider {
    protected GspResourceContextPathAttributeSupport() {
        super("contextPath", "g", GspResourceDirAttributeSupport.TAGS);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport", "getReferencesByElement"));
        }
        String trimedUrl = PathReference.trimPath((String)text);
        if (trimedUrl.trim().length() == 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        WebAppFolderFileReferenceSet set = new WebAppFolderFileReferenceSet(trimedUrl, element, offset, null, true, true){

            @Override
            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                if (!this.isAbsolutePathReference()) {
                    Set<PsiFileSystemItem> set = Collections.emptySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport$1", "computeDefaultContexts"));
                    }
                    return set;
                }
                Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport$1", "computeDefaultContexts"));
                }
                return collection;
            }
        };
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceContextPathAttributeSupport", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

