/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsCompletionContributor;
import org.jetbrains.plugins.grails.spring.InjectedSpringBeanProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrailsInjectedBeanCompletionContributor
extends CompletionContributor {
    public GrailsInjectedBeanCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)GrailsCompletionContributor.grFieldNamePattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiClass aClass;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/grails/spring/GrailsInjectedBeanCompletionContributor$1", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/spring/GrailsInjectedBeanCompletionContributor$1", "addCompletions"));
                }
                PsiElement parent = parameters.getPosition().getParent();
                if (parent instanceof GrField) {
                    if (((GrField)parent).getDeclaredType() != null) {
                        return;
                    }
                } else {
                    assert (parent instanceof GrCodeReferenceElement);
                    PsiElement parent2 = parent.getParent();
                    assert (parent2 instanceof GrClassTypeElement);
                    PsiElement variableDeclaration = parent2.getParent();
                    assert (variableDeclaration instanceof GrVariableDeclaration);
                    if (!((GrVariableDeclaration)variableDeclaration).hasModifierProperty("def")) {
                        return;
                    }
                }
                if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class)) == null) {
                    return;
                }
                if (!InjectedSpringBeanProvider.isSupportInjection(aClass)) {
                    return;
                }
                CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel((PsiElement)aClass);
                HashSet beans = new HashSet(springModel.getAllCommonBeans());
                for (PsiField psiField : aClass.getFields()) {
                    if (!(psiField instanceof GrField)) continue;
                    beans.remove(InjectedSpringBeanProvider.getInjectedBean((PsiVariable)psiField));
                }
                for (SpringBeanPointer beanPointer : beans) {
                    LookupElement lookupElement = SpringConverterUtil.createCompletionVariant((SpringBeanPointer)beanPointer);
                    if (lookupElement == null) continue;
                    result2.addElement(lookupElement);
                }
            }
        });
    }
}

