/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;

public class GroovyIndentProcessor
extends GroovyElementVisitor {
    public static final int GDOC_COMMENT_INDENT = 1;
    private static final TokenSet GSTRING_TOKENS_INNER = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mDOLLAR});
    private Indent myResult = null;
    private IElementType myChildType;
    private GroovyBlock myBlock;
    private PsiElement myChild;

    @NotNull
    public Indent getChildIndent(@NotNull GroovyBlock parentBlock, @NotNull ASTNode child) {
        if (parentBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentBlock", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
        }
        this.myChildType = child.getElementType();
        if (parentBlock instanceof ClosureBodyBlock) {
            if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
                }
                return indent;
            }
            if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
                }
                return indent;
            }
        }
        if (parentBlock instanceof GrLabelBlock) {
            ASTNode first = parentBlock.getNode().getFirstChildNode();
            Indent indent = child == first ? Indent.getNoneIndent() : Indent.getLabelIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
            }
            return indent;
        }
        if (GSTRING_TOKENS_INNER.contains(this.myChildType)) {
            Indent indent = Indent.getAbsoluteNoneIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
            }
            return indent;
        }
        PsiElement parent = parentBlock.getNode().getPsi();
        if (parent instanceof GroovyPsiElement) {
            this.myBlock = parentBlock;
            this.myChild = child.getPsi();
            ((GroovyPsiElement)parent).accept(this);
            if (this.myResult != null) {
                Indent indent = this.myResult;
                if (indent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "getChildIndent"));
        }
        return indent;
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (assertStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assertStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAssertStatement"));
        }
        if (this.myChildType != GroovyTokenTypes.kASSERT) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        if (arrayInitializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializer", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAnnotationArrayInitializer"));
        }
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrMap", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitListOrMap"));
        }
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        if (caseSection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseSection", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitCaseSection"));
        }
        if (this.myChildType != GroovyElementTypes.CASE_LABEL) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitSwitchStatement"));
        }
        if (this.myChildType == GroovyElementTypes.CASE_SECTION) {
            this.myResult = GroovyIndentProcessor.getSwitchCaseIndent(this.getGroovySettings());
        }
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitLabeledStatement"));
        }
        if (this.myChildType == GroovyTokenTypes.mIDENT) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myBlock.getContext().getSettings().getIndentOptions();
            if (indentOptions != null && indentOptions.LABEL_INDENT_ABSOLUTE) {
                this.myResult = Indent.getAbsoluteLabelIndent();
            } else if (!this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
                this.myResult = Indent.getLabelIndent();
            }
        } else if (this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
            this.myResult = Indent.getLabelIndent();
        }
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAnnotation"));
        }
        this.myResult = this.myChildType == GroovyElementTypes.ANNOTATION_ARGUMENTS ? Indent.getContinuationIndent() : Indent.getNoneIndent();
    }

    @Override
    public void visitArgumentList(@NotNull GrArgumentList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitArgumentList"));
        }
        if (this.myChildType != GroovyTokenTypes.mLPAREN && this.myChildType != GroovyTokenTypes.mRPAREN) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitIfStatement"));
        }
        if (TokenSets.BLOCK_SET.contains(this.myChildType)) {
            if (this.myChild == ifStatement.getCondition()) {
                this.myResult = Indent.getContinuationWithoutFirstIndent();
            }
        } else if (this.myChild == ifStatement.getThenBranch()) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == ifStatement.getElseBranch()) {
            this.myResult = this.getGroovySettings().SPECIAL_ELSE_IF_TREATMENT && this.myChildType == GroovyElementTypes.IF_STATEMENT ? Indent.getNoneIndent() : Indent.getNormalIndent();
        }
    }

    @Override
    public void visitAnnotationArgumentList(@NotNull GrAnnotationArgumentList annotationArgumentList) {
        if (annotationArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationArgumentList", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAnnotationArgumentList"));
        }
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    @Override
    public void visitNamedArgument(@NotNull GrNamedArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitNamedArgument"));
        }
        if (this.myChild == argument.getExpression()) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitVariable"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitDocComment(@NotNull GrDocComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitDocComment"));
        }
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_COMMENT_START) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        if (variableDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDeclaration", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitVariableDeclaration"));
        }
        if (this.myChild instanceof GrVariable) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitDocTag(@NotNull GrDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitDocTag"));
        }
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_TAG_NAME) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitConditionalExpression"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAssignmentExpression"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitThrowsClause(@NotNull GrThrowsClause throwsClause) {
        if (throwsClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwsClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitThrowsClause"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitImplementsClause(@NotNull GrImplementsClause implementsClause) {
        if (implementsClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementsClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitImplementsClause"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitDocMethodParameterList(@NotNull GrDocMethodParams params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitDocMethodParameterList"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExtendsClause(@NotNull GrExtendsClause extendsClause) {
        if (extendsClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendsClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitExtendsClause"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitFile"));
        }
        this.myResult = Indent.getNoneIndent();
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitMethod"));
        }
        if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
            this.myResult = Indent.getContinuationIndent();
        } else if (this.myChildType == GroovyElementTypes.THROW_CLAUSE) {
            this.myResult = this.getGroovySettings().ALIGN_THROWS_KEYWORD ? Indent.getNoneIndent() : Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitTypeDefinition"));
        }
        if (this.myChildType == GroovyElementTypes.EXTENDS_CLAUSE || this.myChildType == GroovyElementTypes.IMPLEMENTS_CLAUSE) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        if (typeDefinitionBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinitionBody", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitTypeDefinitionBody"));
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitClosure"));
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitOpenBlock"));
        }
        IElementType type = block.getNode().getElementType();
        if (type != GroovyElementTypes.OPEN_BLOCK && type != GroovyElementTypes.CONSTRUCTOR_BODY) {
            return;
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitWhileStatement"));
        }
        if (this.myChild == whileStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == whileStatement.getCondition()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
        if (synchronizedStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synchronizedStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitSynchronizedStatement"));
        }
        if (this.myChild == synchronizedStatement.getMonitor()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitForStatement"));
        }
        if (this.myChild == forStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == forStatement.getClause()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    private CommonCodeStyleSettings getGroovySettings() {
        return this.myBlock.getContext().getSettings();
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitParenthesizedExpression"));
        }
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    public static Indent getSwitchCaseIndent(CommonCodeStyleSettings settings) {
        if (settings.INDENT_CASE_FROM_SWITCH) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitParameterList"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitArrayDeclaration(@NotNull GrArrayDeclaration arrayDeclaration) {
        if (arrayDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayDeclaration", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitArrayDeclaration"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitExpression"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        if (typeArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentList", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitTypeArgumentList"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitCodeReferenceElement"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitWildcardTypeArgument(@NotNull GrWildcardTypeArgument wildcardTypeArgument) {
        if (wildcardTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardTypeArgument", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitWildcardTypeArgument"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAnnotationMethod(@NotNull GrAnnotationMethod annotationMethod) {
        if (annotationMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationMethod", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAnnotationMethod"));
        }
        if (this.myChild instanceof GrAnnotationMemberValue) {
            this.myResult = Indent.getContinuationIndent();
        } else {
            super.visitAnnotationMethod(annotationMethod);
        }
    }

    @Override
    public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
        if (nameValuePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValuePair", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitAnnotationNameValuePair"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        if (forInClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forInClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitForInClause"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForClause(@NotNull GrForClause forClause) {
        if (forClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitForClause"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCatchClause(@NotNull GrCatchClause catchClause) {
        if (catchClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchClause", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitCatchClause"));
        }
        this.myResult = this.myChild == catchClause.getBody() ? Indent.getNoneIndent() : Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTypeParameterList(@NotNull GrTypeParameterList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor", "visitTypeParameterList"));
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }
}

