/*
 * Decompiled with CFR 0.152.
 */
package io.socket;

import io.socket.IOConnection;
import io.socket.IOTransport;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

class XhrTransport
implements IOTransport {
    public static final String TRANSPORT_NAME = "xhr-polling";
    private IOConnection connection;
    private URL url;
    ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    PollThread pollThread = null;
    private boolean connect;
    private boolean blocked;
    HttpURLConnection urlConnection;

    public static IOTransport create(URL url, IOConnection connection) {
        try {
            URL xhrUrl = new URL(url.toString() + "/socket.io/1/" + TRANSPORT_NAME + "/" + connection.getSessionId());
            return new XhrTransport(xhrUrl, connection);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed Internal url. This should never happen. Please report a bug.", e);
        }
    }

    public XhrTransport(URL url, IOConnection connection) {
        this.connection = connection;
        this.url = url;
    }

    @Override
    public void connect() {
        this.setConnect(true);
        this.pollThread = new PollThread();
        this.pollThread.start();
    }

    @Override
    public void disconnect() {
        this.setConnect(false);
        this.pollThread.interrupt();
    }

    @Override
    public void send(String text) throws IOException {
        this.sendBulk(new String[]{text});
    }

    @Override
    public boolean canSendBulk() {
        return true;
    }

    @Override
    public void sendBulk(String[] texts) throws IOException {
        this.queue.addAll(Arrays.asList(texts));
        if (this.isBlocked()) {
            this.pollThread.interrupt();
            this.urlConnection.disconnect();
        }
    }

    @Override
    public void invalidate() {
        this.connection = null;
    }

    private synchronized boolean isConnect() {
        return this.connect;
    }

    private synchronized void setConnect(boolean connect) {
        this.connect = connect;
    }

    private synchronized boolean isBlocked() {
        return this.blocked;
    }

    private synchronized void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public String getName() {
        return TRANSPORT_NAME;
    }

    private class PollThread
    extends Thread {
        private static final String CHARSET = "UTF-8";

        public PollThread() {
            super(XhrTransport.TRANSPORT_NAME);
        }

        @Override
        public void run() {
            XhrTransport.this.connection.transportConnected();
            while (XhrTransport.this.isConnect()) {
                block13: {
                    try {
                        Closeable input;
                        String line;
                        URL url = new URL(XhrTransport.this.url.toString() + "?t=" + System.currentTimeMillis());
                        XhrTransport.this.urlConnection = (HttpURLConnection)url.openConnection();
                        SSLContext context = IOConnection.getSslContext();
                        if (XhrTransport.this.urlConnection instanceof HttpsURLConnection && context != null) {
                            ((HttpsURLConnection)XhrTransport.this.urlConnection).setSSLSocketFactory(context.getSocketFactory());
                        }
                        if (!XhrTransport.this.queue.isEmpty()) {
                            XhrTransport.this.urlConnection.setDoOutput(true);
                            OutputStream output = XhrTransport.this.urlConnection.getOutputStream();
                            if (XhrTransport.this.queue.size() == 1) {
                                line = XhrTransport.this.queue.poll();
                                output.write(line.getBytes(CHARSET));
                            } else {
                                Iterator<String> iter = XhrTransport.this.queue.iterator();
                                while (iter.hasNext()) {
                                    String junk = iter.next();
                                    line = "\ufffd" + junk.length() + "\ufffd" + junk;
                                    output.write(line.getBytes(CHARSET));
                                    iter.remove();
                                }
                            }
                            output.close();
                            input = XhrTransport.this.urlConnection.getInputStream();
                            byte[] buffer = new byte[1024];
                            while (((InputStream)input).read(buffer) > 0) {
                            }
                            ((InputStream)input).close();
                        } else {
                            XhrTransport.this.setBlocked(true);
                            InputStream plainInput = XhrTransport.this.urlConnection.getInputStream();
                            input = new BufferedReader(new InputStreamReader(plainInput, CHARSET));
                            while ((line = ((BufferedReader)input).readLine()) != null) {
                                if (XhrTransport.this.connection == null) continue;
                                XhrTransport.this.connection.transportData(line);
                            }
                            XhrTransport.this.setBlocked(false);
                        }
                    }
                    catch (IOException e) {
                        if (XhrTransport.this.connection == null || PollThread.interrupted()) break block13;
                        XhrTransport.this.connection.transportError(e);
                        return;
                    }
                }
                try {
                    PollThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            XhrTransport.this.connection.transportDisconnected();
        }
    }
}

