/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.agent;

import com.intellij.javaee.oss.geronimo.agent.GeronimoAgentBase;
import java.io.IOException;
import java.util.Set;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryImpl;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.jmx.KernelDelegate;

public class Geronimo11Agent
extends GeronimoAgentBase {
    private Kernel myKernel;

    protected boolean connectKernel() {
        try {
            return this.getKernel().isRunning() && Geronimo11Agent.isStarted(this.getKernel());
        }
        catch (Exception e) {
            this.getLog().debugEx(e);
            return false;
        }
    }

    private Kernel getKernel() throws IOException {
        if (this.myKernel == null) {
            this.myKernel = new KernelDelegate(this.createConnection());
        }
        return this.myKernel;
    }

    private static boolean isStarted(Kernel k) throws Exception {
        Set configs = k.listGBeans(new AbstractNameQuery(PersistentConfigurationList.class.getName()));
        return !configs.isEmpty() && Boolean.TRUE.equals(k.getAttribute((AbstractName)configs.iterator().next(), "kernelFullyStarted"));
    }

    protected DeploymentFactory getDeploymentFactory() {
        return new DeploymentFactoryImpl();
    }

    protected boolean matches(TargetModuleID module, String name) {
        return Artifact.create((String)name).matches(Artifact.create((String)module.getModuleID()));
    }
}

