/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChoosePackageDialog
extends DialogWrapper {
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "ChoosePackageDialog.DESTINATION_PACKAGE_RECENT_KEY";
    private JPanel myMainPanel;
    private JSReferenceEditor myPackageCombo;
    private final Module myModule;
    private final String myPackageNameInitial;
    private final PsiFile myContextFile;
    private PsiDirectory myTargetDirectory;

    protected ChoosePackageDialog(Module module, String title, String packageNameInitial, PsiFile contextFile) {
        super(module.getProject());
        this.myModule = module;
        this.myPackageNameInitial = packageNameInitial;
        this.myContextFile = contextFile;
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPackageCombo.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        String packageName = this.getPackageName();
        for (String s : StringUtil.split((String)packageName, (String)".")) {
            if (namesValidator.isIdentifier(s, null)) continue;
            this.setErrorText(JSBundle.message((String)"invalid.package", (Object[])new Object[]{packageName}));
            return;
        }
        this.myPackageCombo.updateRecents();
        this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)this.myModule.getProject(), (Module)this.myModule, (GlobalSearchScope)this.getPackageScope(), (String)packageName, null, (PsiDirectory)this.myContextFile.getParent(), (ThreeState)ThreeState.UNSURE);
        if (this.myTargetDirectory != null) {
            super.doOKAction();
        }
    }

    private GlobalSearchScope getPackageScope() {
        return PlatformPackageUtil.adjustScope((PsiDirectory)this.myContextFile.getParent(), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule), (boolean)false, (boolean)true);
    }

    private void createUIComponents() {
        this.myPackageCombo = JSReferenceEditor.forPackageName((String)this.myPackageNameInitial, (Project)this.myModule.getProject(), (String)DESTINATION_PACKAGE_RECENT_KEY, (GlobalSearchScope)this.getPackageScope(), (String)RefactoringBundle.message((String)"choose.destination.package"));
    }

    public String getPackageName() {
        return this.myPackageCombo.getText().trim();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Target package:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myPackageCombo;
        jPanel.add((Component)jSReferenceEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(250, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

