/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.psi;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ProcessingContext;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.editor.CoffeeScriptSelectionHandler;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/coffeescript/lang/psi/CoffeeScriptReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return CoffeeScriptUtil.getHeredoc((PsiElement)element) != null;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/coffeescript/lang/psi/CoffeeScriptReferenceContributor$1", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "org/coffeescript/lang/psi/CoffeeScriptReferenceContributor$1", "getReferencesByElement"));
                }
                JSReferenceSet refSet = new JSReferenceSet(psiElement){

                    public void update(String text, int offset) {
                        if (this.myReferences != null && this.myReferenceText != null && this.myReferenceText.equals(text) && this.myOffset == offset) {
                            return;
                        }
                        this.myReferenceText = text;
                        this.myOffset = offset;
                        TextRange contentRange = CoffeeScriptSelectionHandler.createRangeForHeredocStringContent(this.getElement());
                        TextRange rangeInElement = contentRange.shiftRight(-this.getElement().getTextRange().getStartOffset());
                        this.myReferences = this.reparse(rangeInElement.substring(text), offset + rangeInElement.getStartOffset());
                    }
                };
                refSet.update(psiElement.getText(), 0);
                PsiReference[] psiReferenceArray = refSet.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/psi/CoffeeScriptReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

