/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FieldRetrievingFactoryBeanConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    protected final boolean mySoft;

    protected FieldRetrievingFactoryBeanConverter() {
        this(true);
    }

    protected FieldRetrievingFactoryBeanConverter(boolean soft) {
        this.mySoft = soft;
    }

    protected boolean requireFieldReference() {
        return false;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(genericDomValue, element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element) {
        PsiReference reference;
        PsiElement psiElement;
        String stringValue = genericDomValue.getStringValue();
        if (stringValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> collectedReferences = new ArrayList<PsiReference>();
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        provider.setSoft(this.mySoft);
        provider.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.TRUE);
        PsiReference[] javaClassReferences = provider.getReferencesByElement(element);
        PsiClass psiClass = null;
        PsiReference[] psiReferenceArray = javaClassReferences;
        int n = psiReferenceArray.length;
        for (int i = 0; i < n && (psiElement = (reference = psiReferenceArray[i]).resolve()) != null; ++i) {
            collectedReferences.add(reference);
            if (!(psiElement instanceof PsiClass)) continue;
            psiClass = (PsiClass)psiElement;
        }
        if (psiClass == null || !this.requireFieldReference() && stringValue.endsWith(psiClass.getQualifiedName())) {
            return javaClassReferences;
        }
        collectedReferences.add(this.createFieldReference(psiClass, element, stringValue, genericDomValue));
        return collectedReferences.toArray(new PsiReference[collectedReferences.size()]);
    }

    private PsiReference createFieldReference(PsiClass psiClass, PsiElement element, String stringValue, GenericDomValue<String> genericDomValue) {
        String className = psiClass.getName();
        assert (className != null);
        int fieldNameIdx = stringValue.lastIndexOf(className) + className.length();
        String fieldName = stringValue.substring(Math.min(stringValue.length(), fieldNameIdx + 1)).trim();
        TextRange textRange = fieldName.isEmpty() ? TextRange.from((int)(element.getText().indexOf(className) + className.length() + 1), (int)0) : TextRange.from((int)Math.max(0, element.getText().lastIndexOf(fieldName)), (int)fieldName.length());
        return new FieldReference(element, textRange, fieldName, psiClass, genericDomValue);
    }

    public static class FieldReferenceRequired
    extends FieldRetrievingFactoryBeanConverter {
        @Override
        protected boolean requireFieldReference() {
            return true;
        }
    }

    protected class FieldReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myFieldName;
        private final PsiClass myPsiClass;
        private final GenericDomValue<String> myGenericDomValue;

        protected FieldReference(PsiElement element, TextRange textRange, String fieldName, PsiClass psiClass, GenericDomValue<String> genericDomValue) {
            super(element, textRange, FieldRetrievingFactoryBeanConverter.this.mySoft);
            this.myFieldName = fieldName;
            this.myPsiClass = psiClass;
            this.myGenericDomValue = genericDomValue;
        }

        public PsiElement resolve() {
            if (this.myFieldName.length() != 0) {
                PsiField[] psiFields;
                for (PsiField psiField : psiFields = this.myPsiClass.getAllFields()) {
                    if (!psiField.hasModifierProperty("public") || !psiField.hasModifierProperty("static") || !this.myFieldName.equals(psiField.getName())) continue;
                    return psiField;
                }
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference", "bindToElement"));
            }
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                this.myGenericDomValue.setStringValue(field.getContainingClass().getQualifiedName() + "." + field.getName());
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            PsiField[] psiFields;
            ArrayList<LookupElementBuilder> staticFields = new ArrayList<LookupElementBuilder>();
            for (PsiField psiField : psiFields = this.myPsiClass.getFields()) {
                if (!psiField.hasModifierProperty("public") || !psiField.hasModifierProperty("static") || psiField.getName() == null) continue;
                staticFields.add(JavaLookupElementBuilder.forField((PsiField)psiField, (String)psiField.getName(), (PsiClass)this.myPsiClass).withTypeText(psiField.getType().getPresentableText()));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(staticFields);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String fieldName = this.getValue();
            if (fieldName.isEmpty() || fieldName.equals(".")) {
                if ("Field name expected" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference", "getUnresolvedMessagePattern"));
                }
                return "Field name expected";
            }
            String string = "Cannot resolve field '" + fieldName + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

