/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.tree.ExistingBundleElementBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;

public class LibraryBundleElement
extends ExistingBundleElementBase<String> {
    private final boolean myMissing;

    public LibraryBundleElement(Project project, BundleDefinition definition, boolean missing, VirtualFile bundleJar) {
        super(project, LibraryBundleElement.createKey(definition), definition, bundleJar);
        this.myMissing = missing;
    }

    @NonNls
    private static String createKey(BundleDefinition definition) {
        return "library-bundle::" + definition.getSymbolicName() + "::" + definition.getVersion();
    }

    protected void update(PresentationData presentation) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.getDefinition().getSymbolicName());
        nameBuilder.append(" (");
        nameBuilder.append(this.getDefinition().getVersion());
        nameBuilder.append(")");
        String name = nameBuilder.toString();
        if (this.myMissing) {
            name = DmServerBundle.message("LibraryBundleElement.name.missing", name);
        }
        LibraryBundleElement.updateStyledText(presentation, name, false);
        LibraryBundleElement.updateIcons(presentation);
    }
}

