/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.utils.SpringCommonUtils;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringGlobalVariableProvider
extends FtlGlobalVariableProvider {
    @NonNls
    public static final String SPRING_FTL_PACKAGE = "org.springframework.web.servlet.view.freemarker";
    @NonNls
    public static final String SPRING_FTL = "spring.ftl";

    @Override
    @NotNull
    public List<? extends FtlVariable> getGlobalVariables(FtlFile _file) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)_file);
        if (module == null || SpringCommonUtils.hasSpringFacet((Module)module)) {
            List<FtlLightVariable> list = Collections.singletonList(new FtlLightVariable("springMacroRequestContext", (PsiElement)_file, "org.springframework.web.servlet.support.RequestContext"));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/SpringGlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/SpringGlobalVariableProvider", "getGlobalVariables"));
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, FtlFile> getSpecialFileReferenceValues(@NotNull FtlFile _file) {
        if (_file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_file", "com/intellij/freemarker/psi/files/SpringGlobalVariableProvider", "getSpecialFileReferenceValues"));
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)_file.getProject()).findPackage(SPRING_FTL_PACKAGE);
        if (aPackage != null) {
            for (PsiDirectory directory : aPackage.getDirectories(_file.getResolveScope())) {
                PsiFile file = directory.findFile(SPRING_FTL);
                if (!(file instanceof FtlFile)) continue;
                THashMap result = new THashMap();
                result.put(SPRING_FTL, (FtlFile)file);
                result.put("/spring.ftl", (FtlFile)file);
                THashMap tHashMap = result;
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/SpringGlobalVariableProvider", "getSpecialFileReferenceValues"));
                }
                return tHashMap;
            }
        }
        Map<String, FtlFile> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/SpringGlobalVariableProvider", "getSpecialFileReferenceValues"));
        }
        return map;
    }
}

