/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.tools.klint.client.api.AndroidReference;
import com.android.tools.klint.client.api.JavaParser;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.JavaContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UVariableDeclarationsExpression;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.expressions.UTypeReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class UElementVisitor {
    private static final int SAME_TYPE_COUNT = 8;
    private final Map<String, List<VisitingDetector>> mMethodDetectors = Maps.newHashMapWithExpectedSize((int)80);
    private final Map<String, List<VisitingDetector>> mConstructorDetectors = Maps.newHashMapWithExpectedSize((int)12);
    private final Map<String, List<VisitingDetector>> mReferenceDetectors = Maps.newHashMapWithExpectedSize((int)10);
    private Set<String> mConstructorSimpleNames;
    private final List<VisitingDetector> mResourceFieldDetectors = new ArrayList<VisitingDetector>();
    private final List<VisitingDetector> mAllDetectors;
    private final List<VisitingDetector> mFullTreeDetectors;
    private final Map<Class<? extends UElement>, List<VisitingDetector>> mNodePsiTypeDetectors = new HashMap<Class<? extends UElement>, List<VisitingDetector>>(16);
    private final JavaParser mParser;
    private final Map<String, List<VisitingDetector>> mSuperClassDetectors = new HashMap<String, List<VisitingDetector>>();
    private static int sExceptionCount;
    private static final int MAX_REPORTED_CRASHES = 20;

    /*
     * WARNING - void declaration
     */
    UElementVisitor(JavaParser parser, List<Detector> detectors) {
        this.mParser = parser;
        this.mAllDetectors = new ArrayList<VisitingDetector>(detectors.size());
        this.mFullTreeDetectors = new ArrayList<VisitingDetector>(detectors.size());
        for (Detector detector : detectors) {
            List<String> list;
            List<String> types;
            List<String> applicableSuperClasses;
            Detector.UastScanner uastScanner = (Detector.UastScanner)((Object)detector);
            VisitingDetector v = new VisitingDetector(detector, uastScanner);
            this.mAllDetectors.add(v);
            List<String> names = detector.getApplicableMethodNames();
            if (names != null) {
                assert (names != Detector.XmlScanner.ALL);
                for (String string : names) {
                    List<VisitingDetector> list2 = this.mMethodDetectors.get(string);
                    if (list2 == null) {
                        list2 = new ArrayList<VisitingDetector>(8);
                        this.mMethodDetectors.put(string, list2);
                    }
                    list2.add(v);
                }
            }
            if ((applicableSuperClasses = detector.applicableSuperClasses()) != null) {
                for (Object fqn : applicableSuperClasses) {
                    void var11_18;
                    List<VisitingDetector> list3 = this.mSuperClassDetectors.get(fqn);
                    if (list3 == null) {
                        ArrayList arrayList = new ArrayList(8);
                        this.mSuperClassDetectors.put((String)fqn, arrayList);
                    }
                    var11_18.add(v);
                }
                continue;
            }
            List<Class<? extends UElement>> list4 = detector.getApplicableUastTypes();
            if (list4 != null) {
                Object fqn;
                fqn = list4.iterator();
                while (fqn.hasNext()) {
                    Class clazz = (Class)fqn.next();
                    List<VisitingDetector> list5 = this.mNodePsiTypeDetectors.get(clazz);
                    if (list5 == null) {
                        list5 = new ArrayList<VisitingDetector>(8);
                        this.mNodePsiTypeDetectors.put(clazz, list5);
                    }
                    list5.add(v);
                }
            }
            if ((types = detector.getApplicableConstructorTypes()) != null) {
                assert (types != Detector.XmlScanner.ALL);
                if (this.mConstructorSimpleNames == null) {
                    this.mConstructorSimpleNames = Sets.newHashSet();
                }
                for (String type3 : types) {
                    List<VisitingDetector> list6 = this.mConstructorDetectors.get(type3);
                    if (list6 == null) {
                        list6 = new ArrayList<VisitingDetector>(8);
                        this.mConstructorDetectors.put(type3, list6);
                        this.mConstructorSimpleNames.add(type3.substring(type3.lastIndexOf(46) + 1));
                    }
                    list6.add(v);
                }
            }
            if ((list = detector.getApplicableReferenceNames()) != null) {
                assert (list != Detector.XmlScanner.ALL);
                for (String name : list) {
                    List<VisitingDetector> list7 = this.mReferenceDetectors.get(name);
                    if (list7 == null) {
                        list7 = new ArrayList<VisitingDetector>(8);
                        this.mReferenceDetectors.put(name, list7);
                    }
                    list7.add(v);
                }
            }
            if (detector.appliesToResourceRefs()) {
                this.mResourceFieldDetectors.add(v);
                continue;
            }
            if (list != null && !list.isEmpty() || list4 != null && !list4.isEmpty() || types != null && !types.isEmpty()) continue;
            this.mFullTreeDetectors.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(final JavaContext context) {
        try {
            Project ideaProject = context.getParser().getIdeaProject();
            if (ideaProject == null) {
                return;
            }
            VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(context.file.getAbsolutePath());
            if (virtualFile == null) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)ideaProject).findFile(virtualFile);
            if (psiFile == null) {
                return;
            }
            UElement uElement = context.getUastContext().convertElementWithParent((PsiElement)psiFile, UFile.class);
            if (!(uElement instanceof UFile)) {
                return;
            }
            final UFile uFile = (UFile)uElement;
            try {
                context.setUFile(uFile);
                this.mParser.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        for (VisitingDetector v : UElementVisitor.this.mAllDetectors) {
                            v.setContext(context);
                            v.getDetector().beforeCheckFile(context);
                        }
                    }
                });
                if (!this.mSuperClassDetectors.isEmpty()) {
                    this.mParser.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            SuperclassPsiVisitor visitor = new SuperclassPsiVisitor(context);
                            uFile.accept(visitor);
                        }
                    });
                }
                for (final VisitingDetector v : this.mFullTreeDetectors) {
                    this.mParser.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            UastVisitor visitor = v.getVisitor();
                            ProgressManager.checkCanceled();
                            uFile.accept(visitor);
                        }
                    });
                }
                if (!(this.mMethodDetectors.isEmpty() && this.mResourceFieldDetectors.isEmpty() && this.mConstructorDetectors.isEmpty() && this.mReferenceDetectors.isEmpty())) {
                    this.mParser.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            DelegatingPsiVisitor visitor = new DelegatingPsiVisitor(context);
                            uFile.accept(visitor);
                        }
                    });
                } else if (!this.mNodePsiTypeDetectors.isEmpty()) {
                    this.mParser.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            DispatchPsiVisitor visitor = new DispatchPsiVisitor();
                            uFile.accept(visitor);
                        }
                    });
                }
                this.mParser.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        for (VisitingDetector v : UElementVisitor.this.mAllDetectors) {
                            ProgressManager.checkCanceled();
                            v.getDetector().afterCheckFile(context);
                        }
                    }
                });
            }
            finally {
                this.mParser.dispose(context, uFile);
                context.setUFile(null);
            }
        }
        catch (ProcessCanceledException ideaProject) {
        }
        catch (RuntimeException e) {
            if (sExceptionCount++ > 20) {
                return;
            }
            if (e.getClass().getSimpleName().equals("IndexNotReadyException")) {
                return;
            }
            StringBuilder sb = new StringBuilder(100);
            sb.append("Unexpected failure during lint analysis of ");
            sb.append(context.file.getName());
            sb.append(" (this is a bug in lint or one of the libraries it depends on)\n");
            sb.append(e.getClass().getSimpleName());
            sb.append(':');
            StackTraceElement[] stackTrace = e.getStackTrace();
            int count = 0;
            for (StackTraceElement frame : stackTrace) {
                if (count > 0) {
                    sb.append("<-");
                }
                String className = frame.getClassName();
                sb.append(className.substring(className.lastIndexOf(46) + 1));
                sb.append('.').append(frame.getMethodName());
                sb.append('(');
                sb.append(frame.getFileName()).append(':').append(frame.getLineNumber());
                sb.append(')');
                if (++count == 4) break;
            }
            Throwable throwable = null;
            context.log(throwable, sb.toString(), new Object[0]);
        }
    }

    public static int getCrashCount() {
        return sExceptionCount;
    }

    public static void clearCrashCount() {
        sExceptionCount = 0;
    }

    public void prepare(List<JavaContext> contexts) {
        this.mParser.prepareJavaParse(contexts);
    }

    public void dispose() {
        this.mParser.dispose();
    }

    private static Set<String> getInterfaceNames(Set<String> addTo, PsiClass cls) {
        for (PsiClass resolvedInterface : cls.getInterfaces()) {
            String name = resolvedInterface.getQualifiedName();
            if (addTo == null) {
                addTo = Sets.newHashSet();
            } else if (addTo.contains(name)) continue;
            addTo.add(name);
            UElementVisitor.getInterfaceNames(addTo, resolvedInterface);
        }
        return addTo;
    }

    private class DelegatingPsiVisitor
    extends DispatchPsiVisitor {
        private final JavaContext mContext;
        private final boolean mVisitResources;
        private final boolean mVisitMethods;
        private final boolean mVisitConstructors;
        private final boolean mVisitReferences;

        DelegatingPsiVisitor(JavaContext context) {
            this.mContext = context;
            this.mVisitMethods = !UElementVisitor.this.mMethodDetectors.isEmpty();
            this.mVisitConstructors = !UElementVisitor.this.mConstructorDetectors.isEmpty();
            this.mVisitResources = !UElementVisitor.this.mResourceFieldDetectors.isEmpty();
            this.mVisitReferences = !UElementVisitor.this.mReferenceDetectors.isEmpty();
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            AndroidReference androidReference;
            PsiElement referenced;
            List list;
            if (this.mVisitReferences || this.mVisitResources) {
                ProgressManager.checkCanceled();
            }
            if (this.mVisitReferences && (list = (List)UElementVisitor.this.mReferenceDetectors.get(node.getIdentifier())) != null && (referenced = node.resolve()) != null) {
                for (VisitingDetector v : list) {
                    Detector.UastScanner uastScanner = v.getUastScanner();
                    if (uastScanner == null) continue;
                    uastScanner.visitReference(this.mContext, v.getVisitor(), node, referenced);
                }
            }
            if (this.mVisitResources && (androidReference = UastLintUtils.toAndroidReferenceViaResolve(node)) != null) {
                for (VisitingDetector v : UElementVisitor.this.mResourceFieldDetectors) {
                    Detector.UastScanner uastScanner = v.getUastScanner();
                    if (uastScanner == null) continue;
                    uastScanner.visitResourceReference(this.mContext, v.getVisitor(), androidReference.node, androidReference.getType(), androidReference.getName(), androidReference.getPackage().equals("android"));
                }
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            boolean result = super.visitCallExpression(node);
            ProgressManager.checkCanceled();
            if (UastExpressionUtils.isMethodCall(node)) {
                this.visitMethodCallExpression(node);
            } else if (UastExpressionUtils.isConstructorCall(node)) {
                this.visitNewExpression(node);
            }
            return result;
        }

        private void visitMethodCallExpression(UCallExpression node) {
            PsiMethod function;
            List list;
            String methodName2;
            if (this.mVisitMethods && (methodName2 = node.getMethodName()) != null && (list = (List)UElementVisitor.this.mMethodDetectors.get(methodName2)) != null && (function = node.resolve()) != null) {
                for (VisitingDetector v : list) {
                    Detector.UastScanner scanner = v.getUastScanner();
                    if (scanner == null) continue;
                    scanner.visitMethod(this.mContext, v.getVisitor(), node, this.mContext.getUastContext().getMethod(function));
                }
            }
        }

        private void visitNewExpression(UCallExpression node) {
            if (this.mVisitConstructors) {
                List list;
                PsiMethod resolvedConstructor = node.resolve();
                if (resolvedConstructor == null) {
                    return;
                }
                PsiClass resolvedClass = resolvedConstructor.getContainingClass();
                if (resolvedClass != null && (list = (List)UElementVisitor.this.mConstructorDetectors.get(resolvedClass.getQualifiedName())) != null) {
                    for (VisitingDetector v : list) {
                        Detector.UastScanner javaPsiScanner = v.getUastScanner();
                        if (javaPsiScanner == null) continue;
                        javaPsiScanner.visitConstructor(this.mContext, v.getVisitor(), node, this.mContext.getUastContext().getMethod(resolvedConstructor));
                    }
                }
            }
        }
    }

    private class DispatchPsiVisitor
    extends AbstractUastVisitor {
        private DispatchPsiVisitor() {
        }

        @Override
        public boolean visitAnnotation(UAnnotation node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UAnnotation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotation(node);
                }
            }
            return super.visitAnnotation(node);
        }

        @Override
        public boolean visitCatchClause(UCatchClause node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UCatchClause.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCatchClause(node);
                }
            }
            return super.visitCatchClause(node);
        }

        @Override
        public boolean visitMethod(UMethod node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UMethod.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethod(node);
                }
            }
            return super.visitMethod(node);
        }

        @Override
        public boolean visitVariable(UVariable node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariable(node);
                }
            }
            return super.visitVariable(node);
        }

        @Override
        public boolean visitFile(UFile node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UFile.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitFile(node);
                }
            }
            return super.visitFile(node);
        }

        @Override
        public boolean visitImportStatement(UImportStatement node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UImportStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportStatement(node);
                }
            }
            return super.visitImportStatement(node);
        }

        @Override
        public boolean visitElement(UElement node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitElement(node);
                }
            }
            return super.visitElement(node);
        }

        @Override
        public boolean visitClass(UClass node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UClass.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClass(node);
                }
            }
            return super.visitClass(node);
        }

        @Override
        public boolean visitInitializer(UClassInitializer node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UClassInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInitializer(node);
                }
            }
            return super.visitInitializer(node);
        }

        @Override
        public boolean visitLabeledExpression(ULabeledExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(ULabeledExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLabeledExpression(node);
                }
            }
            return super.visitLabeledExpression(node);
        }

        @Override
        public boolean visitBlockExpression(UBlockExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UBlockExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBlockExpression(node);
                }
            }
            return super.visitBlockExpression(node);
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UCallExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCallExpression(node);
                }
            }
            return super.visitCallExpression(node);
        }

        @Override
        public boolean visitBinaryExpression(UBinaryExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UBinaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpression(node);
                }
            }
            return super.visitBinaryExpression(node);
        }

        @Override
        public boolean visitBinaryExpressionWithType(UBinaryExpressionWithType node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UBinaryExpressionWithType.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpressionWithType(node);
                }
            }
            return super.visitBinaryExpressionWithType(node);
        }

        @Override
        public boolean visitParenthesizedExpression(UParenthesizedExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UParenthesizedExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParenthesizedExpression(node);
                }
            }
            return super.visitParenthesizedExpression(node);
        }

        @Override
        public boolean visitUnaryExpression(UUnaryExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UUnaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitUnaryExpression(node);
                }
            }
            return super.visitUnaryExpression(node);
        }

        @Override
        public boolean visitPrefixExpression(UPrefixExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UPrefixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPrefixExpression(node);
                }
            }
            return super.visitPrefixExpression(node);
        }

        @Override
        public boolean visitPostfixExpression(UPostfixExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UPostfixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPostfixExpression(node);
                }
            }
            return super.visitPostfixExpression(node);
        }

        @Override
        public boolean visitIfExpression(UIfExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UIfExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIfExpression(node);
                }
            }
            return super.visitIfExpression(node);
        }

        @Override
        public boolean visitSwitchExpression(USwitchExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(USwitchExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchExpression(node);
                }
            }
            return super.visitSwitchExpression(node);
        }

        @Override
        public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(USwitchClauseExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchClauseExpression(node);
                }
            }
            return super.visitSwitchClauseExpression(node);
        }

        @Override
        public boolean visitWhileExpression(UWhileExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UWhileExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitWhileExpression(node);
                }
            }
            return super.visitWhileExpression(node);
        }

        @Override
        public boolean visitDoWhileExpression(UDoWhileExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UDoWhileExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDoWhileExpression(node);
                }
            }
            return super.visitDoWhileExpression(node);
        }

        @Override
        public boolean visitForExpression(UForExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UForExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForExpression(node);
                }
            }
            return super.visitForExpression(node);
        }

        @Override
        public boolean visitForEachExpression(UForEachExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UForEachExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForEachExpression(node);
                }
            }
            return super.visitForEachExpression(node);
        }

        @Override
        public boolean visitTryExpression(UTryExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UTryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTryExpression(node);
                }
            }
            return super.visitTryExpression(node);
        }

        @Override
        public boolean visitLiteralExpression(ULiteralExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(ULiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLiteralExpression(node);
                }
            }
            return super.visitLiteralExpression(node);
        }

        @Override
        public boolean visitThisExpression(UThisExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UThisExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThisExpression(node);
                }
            }
            return super.visitThisExpression(node);
        }

        @Override
        public boolean visitSuperExpression(USuperExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(USuperExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSuperExpression(node);
                }
            }
            return super.visitSuperExpression(node);
        }

        @Override
        public boolean visitReturnExpression(UReturnExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UReturnExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReturnExpression(node);
                }
            }
            return super.visitReturnExpression(node);
        }

        @Override
        public boolean visitBreakExpression(UBreakExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UBreakExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBreakExpression(node);
                }
            }
            return super.visitBreakExpression(node);
        }

        @Override
        public boolean visitContinueExpression(UContinueExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UContinueExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitContinueExpression(node);
                }
            }
            return super.visitContinueExpression(node);
        }

        @Override
        public boolean visitThrowExpression(UThrowExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UThrowExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThrowExpression(node);
                }
            }
            return super.visitThrowExpression(node);
        }

        @Override
        public boolean visitArrayAccessExpression(UArrayAccessExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UArrayAccessExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayAccessExpression(node);
                }
            }
            return super.visitArrayAccessExpression(node);
        }

        @Override
        public boolean visitCallableReferenceExpression(UCallableReferenceExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UCallableReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCallableReferenceExpression(node);
                }
            }
            return super.visitCallableReferenceExpression(node);
        }

        @Override
        public boolean visitClassLiteralExpression(UClassLiteralExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UClassLiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassLiteralExpression(node);
                }
            }
            return super.visitClassLiteralExpression(node);
        }

        @Override
        public boolean visitLambdaExpression(ULambdaExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(ULambdaExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLambdaExpression(node);
                }
            }
            return super.visitLambdaExpression(node);
        }

        @Override
        public boolean visitObjectLiteralExpression(UObjectLiteralExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UObjectLiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitObjectLiteralExpression(node);
                }
            }
            return super.visitObjectLiteralExpression(node);
        }

        @Override
        public boolean visitExpressionList(UExpressionList node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UExpressionList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionList(node);
                }
            }
            return super.visitExpressionList(node);
        }

        @Override
        public boolean visitTypeReferenceExpression(UTypeReferenceExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UTypeReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeReferenceExpression(node);
                }
            }
            return super.visitTypeReferenceExpression(node);
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(USimpleNameReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSimpleNameReferenceExpression(node);
                }
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        @Override
        public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UQualifiedReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitQualifiedReferenceExpression(node);
                }
            }
            return super.visitQualifiedReferenceExpression(node);
        }

        @Override
        public boolean visitDeclarationsExpression(UVariableDeclarationsExpression node) {
            List list = (List)UElementVisitor.this.mNodePsiTypeDetectors.get(UVariableDeclarationsExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDeclarationsExpression(node);
                }
            }
            return super.visitDeclarationsExpression(node);
        }
    }

    private class SuperclassPsiVisitor
    extends AbstractUastVisitor {
        private JavaContext mContext;

        public SuperclassPsiVisitor(JavaContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitClass(UClass node) {
            boolean result = super.visitClass(node);
            this.checkClass(node);
            return result;
        }

        private void checkClass(UClass node) {
            ProgressManager.checkCanceled();
            if (node instanceof PsiTypeParameter) {
                return;
            }
            int depth = 0;
            for (UClass cls = node; cls != null; cls = cls.getUastSuperClass()) {
                Set interfaceNames;
                List list = (List)UElementVisitor.this.mSuperClassDetectors.get(cls.getQualifiedName());
                if (list != null) {
                    for (VisitingDetector v : list) {
                        Detector.UastScanner uastScanner = v.getUastScanner();
                        if (uastScanner == null) continue;
                        uastScanner.checkClass(this.mContext, node);
                    }
                }
                if ((interfaceNames = UElementVisitor.getInterfaceNames(null, cls)) == null) continue;
                for (String name : interfaceNames) {
                    list = (List)UElementVisitor.this.mSuperClassDetectors.get(name);
                    if (list == null) continue;
                    for (VisitingDetector v : list) {
                        Detector.UastScanner javaPsiScanner = v.getUastScanner();
                        if (javaPsiScanner == null) continue;
                        javaPsiScanner.checkClass(this.mContext, node);
                    }
                }
                if (++depth != 500) continue;
                break;
            }
        }
    }

    private static class VisitingDetector {
        private UastVisitor mVisitor;
        private JavaContext mContext;
        public final Detector mDetector;
        public final Detector.UastScanner mUastScanner;

        public VisitingDetector(Detector detector, Detector.UastScanner uastScanner) {
            this.mDetector = detector;
            this.mUastScanner = uastScanner;
        }

        public Detector getDetector() {
            return this.mDetector;
        }

        public Detector.UastScanner getUastScanner() {
            return this.mUastScanner;
        }

        public void setContext(JavaContext context) {
            this.mContext = context;
            this.mVisitor = null;
        }

        UastVisitor getVisitor() {
            if (this.mVisitor == null) {
                this.mVisitor = this.mDetector.createUastVisitor(this.mContext);
                if (this.mVisitor == null) {
                    this.mVisitor = new AbstractUastVisitor(){};
                }
            }
            return this.mVisitor;
        }
    }
}

