/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "platformModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "platformPanel", "Ljavax/swing/JPanel;", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "ChromeConnector"})
public final class ReactNativeConfigurationEditor
extends SettingsEditor<ReactNativeRunConfiguration> {
    private final NodePackageField reactNativeField;
    private final NodeJsInterpreterField nodeInterpreterField;
    private final TextFieldWithBrowseButton workingDirField;
    private final JPanel platformPanel;
    private final RadioButtonEnumModel<ReactNativePlatform> platformModel;

    protected void resetEditorFrom(@NotNull ReactNativeRunConfiguration s) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        this.nodeInterpreterField.setInterpreterRef(s.getNodePath());
        NodePackage sPackage = s.getReactNativePackage();
        if (sPackage != null) {
            this.reactNativeField.setSelected(sPackage);
        } else {
            NodePackage defaultPackage = NodePackage.findDefaultPackage((Project)s.getProject(), (String)ReactNativeConfigurationEditorKt.access$getREACT_NATIVE_PACKAGE_NAME$p(), (NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
            if (defaultPackage != null) {
                this.reactNativeField.setSelected(defaultPackage);
            }
        }
        this.workingDirField.setText(s.getEffectiveWorkingDirectory());
        this.platformModel.setSelected((Enum)s.getPlatform());
    }

    protected void applyEditorTo(@NotNull ReactNativeRunConfiguration s) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        s.setReactNativePackage(this.reactNativeField.getSelected());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"nodeInterpreterField.interpreterRef");
        s.setNodePath(nodeJsInterpreterRef);
        if (Intrinsics.areEqual((Object)this.workingDirField.getText(), (Object)s.findWorkingDirectory())) {
            string = "";
        } else {
            String string2 = this.workingDirField.getText();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workingDirField.text");
        }
        s.setWorkingDirectory(string);
        Enum enum_ = this.platformModel.getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"platformModel.selected");
        s.setPlatform((ReactNativePlatform)enum_);
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = FormBuilder.createFormBuilder().addLabeledComponent("Node &interpreter:", (JComponent)this.nodeInterpreterField).addLabeledComponent("&React Native package:", (JComponent)this.reactNativeField).addLabeledComponent("&Working directory:", (JComponent)this.workingDirField).addLabeledComponent("Target platform:", (JComponent)this.platformPanel).getPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"FormBuilder.createFormBu\u2026formPanel)\n        .panel");
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    public ReactNativeConfigurationEditor(@NotNull Project project) {
        void $receiver$iv;
        void destination$iv$iv;
        Iterable $receiver$iv$iv;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.nodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.reactNativeField = new NodePackageField(project, ReactNativeConfigurationEditorKt.access$getREACT_NATIVE_PACKAGE_NAME$p(), (Supplier)new Supplier<NodeJsInterpreter>(){

            @Override
            @Nullable
            public final NodeJsInterpreter get() {
                return nodeInterpreterField.getInterpreter();
            }
        });
        this.workingDirField = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.workingDirField.addBrowseFolderListener((String)null, (String)null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(this.workingDirField.getTextField(), descriptor, false, (Disposable)this.workingDirField);
        Object[] objectArray = (Object[])ReactNativePlatform.values();
        void var5_4 = $receiver$iv2;
        Collection collection = new ArrayList(((void)$receiver$iv2).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            ReactNativePlatform reactNativePlatform = (ReactNativePlatform)item$iv$iv;
            void var14_11 = destination$iv$iv;
            JRadioButton button = new JRadioButton(it.getReadableName());
            button.setMargin(new Insets(0, 0, 0, 20));
            JRadioButton jRadioButton = button;
            var14_11.add(jRadioButton);
        }
        List buttons = (List)destination$iv$iv;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.platformPanel = new JPanel(new FlowLayout(3, 0, 0));
        $receiver$iv$iv = buttons;
        for (Object element$iv : $receiver$iv) {
            JRadioButton it = (JRadioButton)element$iv;
            buttonGroup.add(it);
            this.platformPanel.add(it);
        }
        RadioButtonEnumModel radioButtonEnumModel = RadioButtonEnumModel.bindEnum(ReactNativePlatform.class, (ButtonGroup)buttonGroup);
        Intrinsics.checkExpressionValueIsNotNull((Object)radioButtonEnumModel, (String)"RadioButtonEnumModel.bin\u2026:class.java, buttonGroup)");
        this.platformModel = radioButtonEnumModel;
    }
}

