/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.filters.Filter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReactNativeProjectGenerator
extends NpmPackageProjectGenerator {
    public static final String REACT_NATIVE_CLI = "react-native-cli";

    @Nls
    @NotNull
    public String getName() {
        if ("React Native" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "getName"));
        }
        return "React Native";
    }

    public String getDescription() {
        return "<a href='https://facebook.github.io/react-native/'>React Native</a> lets you build mobile apps using only JavaScript. It uses the same design as React, letting you compose a rich mobile UI from declarative components.";
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "filters"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "filters"));
        }
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "filters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    @NotNull
    protected String executable(String path) {
        String string = path + File.separator + "index.js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "executable"));
        }
        return string;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "generatorArgs"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "generatorArgs"));
        }
        String[] stringArray = new String[]{"init", baseDir.getName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "generatorArgs"));
        }
        return stringArray;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "customizeModule"));
        }
        if (entry != null) {
            entry.addExcludeFolder(baseDir.getUrl() + "/android");
            entry.addExcludeFolder(baseDir.getUrl() + "/ios");
            Project project = ((ContentEntryImpl)entry).getRootModel().getProject();
            ReactNativeProjectGenerator.setLanguageLevel(project);
        }
    }

    private static void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "createRunConfigurations"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "createRunConfigurations"));
        }
        ConfigurationType configurationType = ConfigurationTypeUtil.findConfigurationType((String)"ReactNative");
        if (configurationType != null) {
            RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
            ReactNativeProjectGenerator.createRunConfiguration(project, runManager, configurationType, ReactNativePlatform.ANDROID, baseDir);
            if (SystemInfo.isMac) {
                ReactNativeProjectGenerator.createRunConfiguration(project, runManager, configurationType, ReactNativePlatform.IOS, baseDir);
            }
        }
    }

    private static void createRunConfiguration(Project project, RunManagerEx runManager, ConfigurationType configurationType, ReactNativePlatform platform, VirtualFile baseDir) {
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(platform.getReadableName(), configurationType.getConfigurationFactories()[0]);
        ReactNativeRunConfiguration rc = (ReactNativeRunConfiguration)settings.getConfiguration();
        rc.setPlatform(platform);
        NodePackage pack = NodePackage.findDefaultPackage((Project)project, (String)REACT_NATIVE_CLI, (NodeJsInterpreter)NodeJsInterpreterRef.createProjectRef().resolve(project));
        if (pack != null) {
            rc.setReactNativePackage(pack);
        }
        rc.setWorkingDirectory(baseDir.getPath());
        runManager.addConfiguration(settings, false);
    }

    private static void setLanguageLevel(Project project) {
        JSRootConfiguration.getInstance((Project)project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
    }

    @NotNull
    protected String packageName() {
        if (REACT_NATIVE_CLI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "packageName"));
        }
        return REACT_NATIVE_CLI;
    }

    @NotNull
    protected String presentablePackageName() {
        if ("React Native" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "presentablePackageName"));
        }
        return "React Native";
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "postInstall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "postInstall"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "postInstall"));
        }
        Runnable runnable = () -> {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$postInstall$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$postInstall$1"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$postInstall$1"));
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$null$0"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$null$0"));
                }
                if (baseDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "lambda$null$0"));
                }
                super.postInstall(node, project, baseDir, workingDir).run();
                ReactNativeProjectGenerator.createRunConfigurations(project, baseDir);
            });
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator", "postInstall"));
        }
        return runnable;
    }

    protected boolean generateInTemp() {
        return true;
    }
}

