/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8Breakpoint;
import org.jetbrains.v8.V8BreakpointManager;
import org.jetbrains.v8.V8BreakpointManager$WhenMappings;
import org.jetbrains.v8.V8BreakpointManagerKt;
import org.jetbrains.v8.V8CommandProcessor;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.FlagsBody;
import org.jetbrains.v8.protocol.FlagsMessage;
import org.jetbrains.v8.protocol.LocationValue;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.SetBreakpointResult;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0011H\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u0002H\u0014J5\u0010$\u001a\u0015\u0012\f\u0012\n %*\u0004\u0018\u00010\u00020\u00020!\u00a2\u0006\u0002\b&2\u0006\u0010\u0019\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020\u0002H\u0014J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0!2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J.\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010/\u001a\u0004\u0018\u000100J\u000e\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u001bJ\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020*0!2\b\u00104\u001a\u0004\u0018\u000105J$\u00106\u001a\b\u0012\u0004\u0012\u00020*0!2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\f0,2\u0006\u00108\u001a\u00020*H\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/v8/V8BreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lorg/jetbrains/v8/V8Breakpoint;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "commandProcessor", "Lorg/jetbrains/v8/V8CommandProcessor;", "getCommandProcessor", "()Lorg/jetbrains/v8/V8CommandProcessor;", "functionSupport", "Lkotlin/Function1;", "", "Lorg/jetbrains/debugger/BreakpointTarget;", "getFunctionSupport", "()Lkotlin/jvm/functions/Function1;", "regExpBreakpointSupported", "", "getRegExpBreakpointSupported", "()Z", "setRegExpBreakpointSupported", "(Z)V", "removedBreakpointIds", "Lgnu/trove/TIntHashSet;", "createBreakpoint", "target", "line", "", "column", "condition", "ignoreCount", "enabled", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "", "breakpoint", "doSetBreakpoint", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "url", "Lcom/intellij/util/Url;", "enableBreakpoints", "", "findRelatedBreakpoints", "", "Lorg/jetbrains/debugger/Breakpoint;", "sourceId", "suggestedBreakpointIds", "", "isBreakpointObsolete", "id", "setBreakOnException", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "setRemoteFlags", "flagNames", "values", "v8-backend"})
public final class V8BreakpointManager
extends BreakpointManagerBase<V8Breakpoint> {
    private final TIntHashSet removedBreakpointIds;
    @NotNull
    private final Function1<String, BreakpointTarget> functionSupport;
    private volatile boolean regExpBreakpointSupported;
    private final V8Vm vm;

    @NotNull
    public Function1<String, BreakpointTarget> getFunctionSupport() {
        return this.functionSupport;
    }

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    public void setRegExpBreakpointSupported(boolean bl) {
        this.regExpBreakpointSupported = bl;
    }

    @NotNull
    public final V8CommandProcessor getCommandProcessor() {
        return this.vm.getCommandProcessor();
    }

    @NotNull
    protected V8Breakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new V8Breakpoint(target, line, column, condition, ignoreCount, enabled);
    }

    @NotNull
    protected Promise<V8Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull V8Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        V8CommandProcessor v8CommandProcessor = this.vm.getCommandProcessor();
        CharSequence charSequence = (CharSequence)target.accept((BreakpointTarget.Visitor)V8BreakpointManagerKt.access$getGET_TYPE_VISITOR$p());
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"target.accept(GET_TYPE_VISITOR)");
        CharSequence charSequence2 = target.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"target.toString()");
        return v8CommandProcessor.send((Request)ProtocolKt.SetBreakpoint$default(charSequence, charSequence2, breakpoint.getLine(), breakpoint.getColumn(), false, breakpoint.getCondition(), breakpoint.getIgnoreCount(), 16, null)).then((Function)new Function<SetBreakpointResult, V8Breakpoint>(this, breakpoint){
            final /* synthetic */ V8BreakpointManager this$0;
            final /* synthetic */ V8Breakpoint $breakpoint;

            @NotNull
            public final V8Breakpoint fun(SetBreakpointResult it) {
                this.$breakpoint.setId(it.getBreakpoint());
                this.$breakpoint.setActualLocations(it.getActual_locations());
                V8BreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
            {
                this.this$0 = v8BreakpointManager;
                this.$breakpoint = v8Breakpoint;
            }
        });
    }

    @NotNull
    protected Promise<Unit> doClearBreakpoint(@NotNull V8Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        this.removedBreakpointIds.add(breakpoint.getId());
        return this.vm.getCommandProcessor().send((Request)ProtocolKt.ClearBreakpoint(breakpoint.getId()));
    }

    public final boolean isBreakpointObsolete(int id) {
        return this.removedBreakpointIds.contains(id);
    }

    @NotNull
    public Promise<boolean[]> enableBreakpoints(boolean enabled) {
        return this.setRemoteFlags(CollectionsKt.listOf((Object)"breakPointsActive"), new boolean[]{enabled});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Promise<boolean[]> setBreakOnException(@Nullable ExceptionCatchMode catchMode) {
        boolean[] flagValues;
        if (catchMode == null) {
            flagValues = new boolean[]{};
            return this.setRemoteFlags(V8BreakpointManagerKt.access$getBREAK_ON_EXCEPTION_FLAG_NAMES$p(), flagValues);
        } else {
            boolean uncaughtValue;
            boolean caughtValue;
            ExceptionCatchMode exceptionCatchMode = catchMode;
            if (exceptionCatchMode == null) throw (Throwable)new RuntimeException();
            switch (V8BreakpointManager$WhenMappings.$EnumSwitchMapping$0[exceptionCatchMode.ordinal()]) {
                case 1: {
                    caughtValue = true;
                    uncaughtValue = true;
                    break;
                }
                case 2: {
                    caughtValue = false;
                    uncaughtValue = false;
                    break;
                }
                case 3: {
                    caughtValue = false;
                    uncaughtValue = true;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException();
                }
            }
            flagValues = new boolean[]{caughtValue, uncaughtValue};
        }
        return this.setRemoteFlags(V8BreakpointManagerKt.access$getBREAK_ON_EXCEPTION_FLAG_NAMES$p(), flagValues);
    }

    /*
     * WARNING - void declaration
     */
    private final Promise<boolean[]> setRemoteFlags(List<String> flagNames, boolean[] values) {
        THashMap flagMap = new THashMap(values.length);
        int n = 0;
        int n2 = ((Collection)flagNames).size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                flagMap.put((Object)flagNames.get((int)i), (Object)values[i]);
                if (i == n2) break;
                ++i;
            }
        }
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new FlagsMessage((Map)flagMap)).then((Function)new Function<FlagsBody, boolean[]>(flagNames){
            final /* synthetic */ List $flagNames;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final boolean[] fun(FlagsBody it) {
                void var3_3;
                List<FlagsBody.FlagInfo> flagList = it.flags();
                boolean[] result = new boolean[this.$flagNames.size()];
                int n = 0;
                int n2 = ((Collection)this.$flagNames).size() - 1;
                if (n <= n2) {
                    while (true) {
                        FlagsBody.FlagInfo f2;
                        void i;
                        block3: {
                            String name = (String)this.$flagNames.get((int)i);
                            for (FlagsBody.FlagInfo f2 : flagList) {
                                if (!Intrinsics.areEqual((Object)name, (Object)f2.name())) continue;
                                break block3;
                            }
                            throw (Throwable)new RuntimeException("Failed to find the correct flag in response");
                        }
                        result[i] = f2.value();
                        if (i == n2) break;
                        ++i;
                    }
                }
                return var3_3;
            }
            {
                this.$flagNames = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor\n    \u2026 }\n        result\n      }");
        return promise2;
    }

    @NotNull
    public final List<Breakpoint> findRelatedBreakpoints(int sourceId, int line, int column, @Nullable int[] suggestedBreakpointIds) {
        SmartList result = new SmartList();
        block0: for (V8Breakpoint breakpoint : this.getBreakpoints()) {
            if (suggestedBreakpointIds != null && ArrayUtil.indexOf((int[])suggestedBreakpointIds, (int)breakpoint.getId()) != -1) {
                result.add((Object)breakpoint);
                continue;
            }
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                if (actualLocation.getScript_id() != sourceId || actualLocation.getLine() != line || actualLocation.getColumn() != column) continue;
                result.add((Object)breakpoint);
                continue block0;
            }
        }
        return (List)result;
    }

    public V8BreakpointManager(@NotNull V8Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.removedBreakpointIds = new TIntHashSet();
        this.functionSupport = functionSupport.1.INSTANCE;
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(V8BreakpointManager $this, @NotNull V8Breakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

