/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanReferenceProvider
extends PsiReferenceProvider {
    private final String myBaseClass;

    BeanReferenceProvider(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider", "getReferencesByElement"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiClass requiredClass = this.myBaseClass == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findClass(this.myBaseClass, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference(element, ElementManipulators.getManipulator((PsiElement)element).getRangeInElement(element), requiredClass, false)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

