/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.MapKeyEnumReference;
import com.intellij.spring.boot.application.properties.MapKeyPropertyReference;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapKeyPropertyEnumReferenceSet {
    @NotNull
    private final PsiElement myElement;
    private final SpringBootApplicationMetaConfigKey myKey;
    private final List<MyReference> myReferences;

    MapKeyPropertyEnumReferenceSet(@NotNull PsiElement element, String text, int offset, SpringBootApplicationMetaConfigKey configKey) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/MapKeyPropertyEnumReferenceSet", "<init>"));
        }
        this.myReferences = new SmartList();
        this.myElement = element;
        this.myKey = configKey;
        assert (this.myKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.INDEXED, SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP})) : configKey;
        this.parse(text, offset);
    }

    private void parse(String text, final int offset) {
        new DelimitedListProcessor("."){
            private int index;
            {
                super(x0);
                this.index = 0;
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                TextRange range = TextRange.create((int)start, (int)end).shiftRight(offset);
                if (MapKeyPropertyEnumReferenceSet.this.myKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.INDEXED})) {
                    this.parseIndexed(range);
                } else {
                    this.parseEnumMap(range);
                }
                ++this.index;
            }

            private void parseIndexed(TextRange range) {
                MapKeyPropertyEnumReferenceSet.this.myReferences.add(new MapKeyPropertyReference(MapKeyPropertyEnumReferenceSet.this.getElement(), range, MapKeyPropertyEnumReferenceSet.this, this.index));
            }

            private void parseEnumMap(TextRange range) {
                if (this.index == 0) {
                    MapKeyPropertyEnumReferenceSet.this.myReferences.add(new MapKeyEnumReference(MapKeyPropertyEnumReferenceSet.this.getElement(), range, MapKeyPropertyEnumReferenceSet.this, 0));
                } else if (this.index == 1) {
                    MapKeyPropertyEnumReferenceSet.this.myReferences.add(new MapKeyPropertyReference(MapKeyPropertyEnumReferenceSet.this.getElement(), range, MapKeyPropertyEnumReferenceSet.this, 1));
                } else {
                    MyReference previousReference = MapKeyPropertyEnumReferenceSet.this.getReference(this.index - 1);
                    PsiClass previousKeyClass = previousReference.getKeyClass();
                    if (previousKeyClass != null && previousKeyClass.isEnum() && previousReference instanceof MapKeyPropertyReference) {
                        MapKeyPropertyEnumReferenceSet.this.myReferences.add(new MapKeyEnumReference(MapKeyPropertyEnumReferenceSet.this.getElement(), range, MapKeyPropertyEnumReferenceSet.this, this.index));
                    } else {
                        MapKeyPropertyEnumReferenceSet.this.myReferences.add(new MapKeyPropertyReference(MapKeyPropertyEnumReferenceSet.this.getElement(), range, MapKeyPropertyEnumReferenceSet.this, this.index));
                    }
                }
            }
        }.processText(text);
    }

    private PsiClass getKeyClass() {
        return this.myKey.getMapKeyType();
    }

    @Nullable
    private PsiClass getValueClass() {
        if (this.isEnumMapKey()) {
            PsiClassType mapValueType = this.myKey.getMapValueType();
            PsiClass listType = MapKeyPropertyEnumReferenceSet.getTypeParameterClass((PsiType)mapValueType, "java.util.List", 0);
            if (listType != null) {
                return listType;
            }
            return PsiTypesUtil.getPsiClass((PsiType)mapValueType);
        }
        PsiType type = this.myKey.getType();
        assert (type != null);
        PsiType v = ((PsiClassType)type).getParameters()[0];
        return PsiTypesUtil.getPsiClass((PsiType)v);
    }

    @NotNull
    private PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyEnumReferenceSet", "getElement"));
        }
        return psiElement;
    }

    private MyReference getReference(int index) {
        return this.myReferences.get(index);
    }

    private boolean isEnumMapKey() {
        return this.myKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP});
    }

    private boolean allowArbitraryKeys() {
        return this.isEnumMapKey();
    }

    public PsiReference[] getReferences() {
        return this.myReferences.toArray(new PsiReference[this.myReferences.size()]);
    }

    @Nullable
    static PsiClass getTypeParameterClass(@Nullable PsiType type, @NotNull String requiredBaseClass, int index) {
        if (requiredBaseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredBaseClass", "com/intellij/spring/boot/application/properties/MapKeyPropertyEnumReferenceSet", "getTypeParameterClass"));
        }
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)requiredBaseClass)) {
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length < index + 1) {
                return null;
            }
            PsiType parameterType = parameters[index];
            return PsiTypesUtil.getPsiClass((PsiType)parameterType);
        }
        return null;
    }

    static abstract class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final MapKeyPropertyEnumReferenceSet myReferenceSet;
        private final int myIndex;

        protected MyReference(PsiElement element, TextRange textRange, MapKeyPropertyEnumReferenceSet referenceSet, int index) {
            super(element, textRange);
            this.myReferenceSet = referenceSet;
            this.myIndex = index;
            this.adjustTextRangeForIndexAccess(textRange);
        }

        private void adjustTextRangeForIndexAccess(TextRange textRange) {
            String elementText = this.getValue();
            if (MyReference.hasIndexedAccess(elementText)) {
                this.setRangeInElement(TextRange.create((int)0, (int)elementText.indexOf("[")).shiftRight(textRange.getStartOffset()));
            }
        }

        private static boolean hasIndexedAccess(String value) {
            return StringUtil.endsWithChar((CharSequence)value, (char)']') && StringUtil.containsChar((String)value, (char)'[');
        }

        @Nullable
        protected abstract PsiClass getValueClass();

        protected PsiClass getInitialValueClass() {
            return this.myReferenceSet.getValueClass();
        }

        @Nullable
        protected abstract PsiClass getKeyClass();

        protected PsiClass getInitialKeyClass() {
            return this.myReferenceSet.getKeyClass();
        }

        protected boolean allowArbitraryKeys() {
            return this.myReferenceSet.allowArbitraryKeys();
        }

        protected boolean isFirst() {
            return this.myIndex == 0;
        }

        protected boolean isLast() {
            return this.myReferenceSet.getReferences().length - 1 == this.myIndex;
        }

        protected MyReference getPrevious() {
            return this.myReferenceSet.getReference(this.myIndex - 1);
        }

        protected final char getKeyValueDelimiter() {
            return PropertiesCodeStyleSettings.getInstance((Project)this.getElement().getProject()).getDelimiter();
        }

        protected boolean isEnumMapKey() {
            return this.myReferenceSet.isEnumMapKey();
        }
    }
}

