/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import icons.SpringBootApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationConfigurationType
extends SpringBootApplicationConfigurationTypeBase {
    @NonNls
    private static final String ID = "SpringBootApplicationConfigurationType";
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx((ConfigurationType)this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationConfigurationType$1", "createTemplateConfiguration"));
            }
            SpringBootApplicationRunConfiguration springBootApplicationRunConfiguration = new SpringBootApplicationRunConfiguration(project, (ConfigurationFactory)this, "");
            if (springBootApplicationRunConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootApplicationConfigurationType$1", "createTemplateConfiguration"));
            }
            return springBootApplicationRunConfiguration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/SpringBootApplicationConfigurationType$1", "isApplicable"));
            }
            return SpringBootLibraryUtil.hasSpringBootLibrary(project);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/SpringBootApplicationConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }

        public boolean isConfigurationSingletonByDefault() {
            return true;
        }
    };

    public String getDisplayName() {
        return "Spring Boot";
    }

    public String getConfigurationTypeDescription() {
        return "Spring Boot Application";
    }

    public Icon getIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/SpringBootApplicationConfigurationType", "getId"));
        }
        return ID;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public ConfigurationFactory getDefaultConfigurationFactory() {
        return this.myFactory;
    }
}

