/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterDialog;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreter
extends NodeJsInterpreter {
    public static final String YARN_PACKAGE_NAME = "yarn";
    private static final String NPM_EXECUTABLE_NAME = SystemInfo.isWindows ? "npm.cmd" : "npm";
    static final String WIN_EXE_EXT = ".exe";
    private final String myInterpreterSystemIndependentPath;
    private final String myInterpreterSystemDependentPath;
    private final File myInterpreter;
    private volatile String myNpmPackageDir;
    private volatile NodeSettings mySettings;

    public NodeJsLocalInterpreter(@NotNull String interpreterPath, @Nullable String npmPackageDir) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "<init>"));
        }
        this.myInterpreterSystemIndependentPath = FileUtil.toSystemIndependentName((String)interpreterPath);
        this.myInterpreterSystemDependentPath = FileUtil.toSystemDependentName((String)interpreterPath);
        this.myInterpreter = new File(interpreterPath);
        if (!StringUtil.isEmptyOrSpaces((String)npmPackageDir)) {
            this.myNpmPackageDir = FileUtil.toSystemDependentName((String)npmPackageDir);
        }
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String path = this.myInterpreterSystemIndependentPath;
        if (SystemInfo.isWindows && path.endsWith(WIN_EXE_EXT)) {
            path = path.substring(0, path.length() - WIN_EXE_EXT.length());
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getReferenceName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String userHome = FileUtil.toSystemDependentName((String)SystemProperties.getUserHome());
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.myInterpreterSystemDependentPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String userHomeWithSeparator = (userHome = StringUtil.trimEnd((String)userHome, (char)File.separatorChar)) + File.separatorChar;
        if (this.myInterpreterSystemDependentPath.startsWith(userHomeWithSeparator)) {
            String string = "~" + this.myInterpreterSystemDependentPath.substring(userHome.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return NodeJsLocalInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<SemVer> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "fetchVersion"));
        }
        NodeJsLocalInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return this.isValid() ? null : "Please specify Node.js interpreter correctly";
    }

    @NotNull
    public String getInterpreterSystemDependentPath() {
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getInterpreterSystemIndependentPath() {
        String string = this.myInterpreterSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemIndependentPath"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myInterpreter.isFile() && this.myInterpreter.canExecute();
    }

    @NotNull
    public NodeJsLocalInterpreterType getType() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
        if (nodeJsLocalInterpreterType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getType"));
        }
        return nodeJsLocalInterpreterType;
    }

    @Override
    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other) && ComparatorUtil.equalsNullable((Object)this.myNpmPackageDir, (Object)((NodeJsLocalInterpreter)other).myNpmPackageDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsLocalInterpreter that = (NodeJsLocalInterpreter)o;
        return this.myInterpreterSystemIndependentPath.equals(that.myInterpreterSystemIndependentPath);
    }

    public int hashCode() {
        return this.myInterpreterSystemIndependentPath.hashCode();
    }

    public String toString() {
        return this.myInterpreterSystemIndependentPath;
    }

    @NotNull
    public String getNpmPackageDir() {
        String npmPackageDirPath = this.myNpmPackageDir;
        if (npmPackageDirPath != null) {
            String string = npmPackageDirPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
            }
            return string;
        }
        File npmPackageDir = this.detectNpmPackageDir();
        this.myNpmPackageDir = npmPackageDirPath = npmPackageDir != null ? npmPackageDir.getAbsolutePath() : "";
        String string = npmPackageDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
        }
        return string;
    }

    public void setNpmPackageDir(@NotNull String npmPackageDir) {
        if (npmPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmPackageDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "setNpmPackageDir"));
        }
        this.myNpmPackageDir = npmPackageDir;
    }

    @NotNull
    public String getNpmPackageDirNoDetection() {
        String string = StringUtil.notNullize((String)this.myNpmPackageDir);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDirNoDetection"));
        }
        return string;
    }

    @Nullable
    private File detectNpmPackageDir() {
        File npmExecutable;
        File binDir;
        if (this.myInterpreter.isFile() && (binDir = this.myInterpreter.getParentFile()) != null) {
            File npmPackageDir = NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(binDir);
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            npmPackageDir = this.guessNpmPackageDirForNodist(binDir);
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            if (this.myInterpreterSystemIndependentPath.contains("/Cellar/") && (npmPackageDir = new File(binDir, "libexec/npm")).isDirectory()) {
                return npmPackageDir;
            }
        }
        if ((npmExecutable = PathEnvironmentVariableUtil.findInPath((String)NPM_EXECUTABLE_NAME, null)) != null) {
            return NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(npmExecutable.getParentFile());
        }
        return null;
    }

    @Nullable
    private File guessNpmPackageDirForNodist(@NotNull File binDir) {
        String nodistPrefix;
        if (binDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "guessNpmPackageDirForNodist"));
        }
        if (SystemInfo.isWindows && (nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")) != null) {
            nodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix);
            if (this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix = StringUtil.trimEnd((String)nodistPrefix, (String)"/") + "/")) {
                File nodistNpmFile;
                File parentDir2;
                File parentDir1 = binDir.getParentFile();
                File file = parentDir2 = parentDir1 != null ? parentDir1.getParentFile() : null;
                if (parentDir2 != null && (nodistNpmFile = new File(parentDir2, "bin\\npm.cmd")).isFile() && nodistNpmFile.canExecute()) {
                    return NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(nodistNpmFile.getParentFile());
                }
            }
        }
        return null;
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        NodeSettings settings = this.mySettings;
        if (settings == null) {
            this.mySettings = settings = new NodeSettings(this.myInterpreterSystemDependentPath);
        }
        return settings.getGlobalNodeModulesVirtualDir();
    }

    @Nullable
    private static File guessNpmPackageDirByNpmBinDir(@Nullable File npmBinDir) {
        if (npmBinDir == null) {
            return null;
        }
        File npmPackageDir = null;
        if (SystemInfo.isWindows) {
            npmPackageDir = new File(npmBinDir, "node_modules\\npm");
        } else {
            File parent = npmBinDir.getParentFile();
            if (parent != null) {
                npmPackageDir = new File(parent, "lib/node_modules/npm");
            }
        }
        return npmPackageDir != null && npmPackageDir.isDirectory() ? npmPackageDir : null;
    }

    @NotNull
    public String getValidNpmCliJsFilePath() throws ExecutionException {
        String string = this.getValidNpmCliJsFilePath(null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
        }
        return string;
    }

    public boolean isYarnAlikePackage() {
        String packageDir = this.getNpmPackageDir();
        String packageName = PathUtil.getFileName((String)packageDir);
        if (StringUtil.containsIgnoreCase((String)packageName, (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        return "libexec".equals(packageName) && packageDir.contains(YARN_PACKAGE_NAME);
    }

    @NotNull
    public String getValidNpmCliJsFilePath(@Nullable Project project) throws ExecutionException {
        String npmPackageDirPath = this.getNpmPackageDir();
        if (StringUtil.isEmpty((String)npmPackageDirPath)) {
            String string = this.invalidNpmPackage(project, "Please specify npm or yarn package");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        File npmPackageDir = new File(npmPackageDirPath);
        if (!npmPackageDir.isAbsolute() || !npmPackageDir.isDirectory()) {
            String string = this.invalidNpmPackage(project, "Please correct path to npm or yarn package: no such directory \"" + npmPackageDirPath + "\"");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        if (this.isYarnAlikePackage()) {
            String string = this.findValidFile(npmPackageDir, "bin" + File.separator + "yarn.js", project);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        String string = this.findValidFile(npmPackageDir, "bin" + File.separator + "npm-cli.js", project);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
        }
        return string;
    }

    @NotNull
    private String findValidFile(@NotNull File packageDir, @NotNull String relativePath, @Nullable Project project) throws ExecutionException {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        File mainJsFile = new File(packageDir, relativePath);
        if (!mainJsFile.isFile()) {
            String string = this.invalidNpmPackage(project, "Please specify npm or yarn package: cannot find \"" + relativePath + "\" inside \"" + packageDir + "\" directory");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
            }
            return string;
        }
        String string = mainJsFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        return string;
    }

    private String invalidNpmPackage(@Nullable Project project, @NotNull String errorMessage) throws ExecutionException {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "invalidNpmPackage"));
        }
        if (project != null) {
            NodeJsLocalInterpreterDialog.edit(project, this);
            return this.getValidNpmCliJsFilePath(null);
        }
        throw new ExecutionException(errorMessage);
    }

    public boolean isElectron() {
        return this.myInterpreterSystemIndependentPath.endsWith("/Contents/MacOS/Electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron.cmd");
    }

    @Nullable
    public static NodeJsLocalInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class);
    }

    @NotNull
    public static NodeJsLocalInterpreter cast(@Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        if (interpreter == null) {
            throw new ExecutionException("Please specify Node.js interpreter");
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new ExecutionException("Please specify local Node.js interpreter");
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "cast"));
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public static NodeJsLocalInterpreter castAndValidate(@Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (localInterpreter.isValid()) {
            NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
            if (nodeJsLocalInterpreter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "castAndValidate"));
            }
            return nodeJsLocalInterpreter;
        }
        throw new ExecutionException("Please specify Node.js interpreter correctly");
    }

    @Nullable
    public static String getErrorMessage(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            return "Please specify local Node.js interpreter";
        }
        return localInterpreter.validate(null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        String errorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }
}

