/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeModulesRootsProvider
extends AdditionalLibraryRootsProvider {
    private static final Logger LOG = Logger.getInstance(NodeModulesRootsProvider.class);

    @NotNull
    public Collection<VirtualFile> getAdditionalProjectLibrarySourceRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesRootsProvider", "getAdditionalProjectLibrarySourceRoots"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List<VirtualFile> roots = (List<VirtualFile>)manager.computeFileIndexExtensionPreventingRecursion(() -> NodeModulesRootsProvider.computeRoots(manager));
        List<VirtualFile> list = roots != null ? roots : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesRootsProvider", "getAdditionalProjectLibrarySourceRoots"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> computeRoots(@NotNull NodeModulesDirectoryManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/nodejs/library/NodeModulesRootsProvider", "computeRoots"));
        }
        List<NodeModulesLibraryDirectory> libraryDirs = manager.getNodeModulesDirectories();
        if (libraryDirs.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesRootsProvider", "computeRoots"));
            }
            return list;
        }
        ArrayList enabled = ContainerUtil.newArrayList();
        for (NodeModulesLibraryDirectory libraryDir : libraryDirs) {
            if (!manager.isLibraryWithMappings(libraryDir)) continue;
            ScriptingLibraryModel libraryModel = libraryDir.getLibraryModel();
            if (libraryModel != null) {
                enabled.addAll(ContainerUtil.filter((Collection)libraryModel.getSourceFiles(), VirtualFile::isValid));
                continue;
            }
            LOG.warn("No preloaded library for " + libraryDir.getNodeModulesDir().getPath());
        }
        ArrayList arrayList = enabled;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesRootsProvider", "computeRoots"));
        }
        return arrayList;
    }
}

