/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class JSInsertThisFix
extends FixAndIntentionAction {
    private final boolean myStatic;

    public JSInsertThisFix(JSExpression node) {
        this.registerElementRefForFix((PsiElement)node, null);
        this.myStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)node);
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)(this.myStatic ? "insert.class.fix.name" : "insert.this.keyword.fix.name"), (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/JSInsertThisFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, final PsiElement psiElement, PsiFile file, final Editor editor) {
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                JSClass context;
                String qualifier = "this";
                if (JSInsertThisFix.this.myStatic && (context = JSResolveUtil.getClassOfContext(psiElement)) != null && context.getName() != null) {
                    qualifier = context.getName();
                }
                JSInsertThisFix.insertQualifier((JSExpression)psiElement, editor, qualifier);
            }
        });
    }

    public static JSExpression insertThisQualifier(JSExpression expression, Editor editor) {
        return JSInsertThisFix.insertQualifier(expression, editor, "this");
    }

    public static JSExpression insertQualifier(JSExpression expression, Editor editor, String qualifier) {
        ApplicationManager.getApplication().isDispatchThread();
        Ref result = Ref.create((Object)expression);
        ApplicationManager.getApplication().runWriteAction(() -> {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Runnable runnable = () -> {
                ASTNode expressionFromText = JSChangeUtil.createExpressionFromText(expression.getProject(), qualifier + "." + expression.getText());
                expression.getParent().getNode().replaceChild(expression.getNode(), expressionFromText);
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)expression.getProject());
                instance.doPostponedOperationsAndUnblockDocument(editor.getDocument());
                result.set((Object)((JSExpression)expressionFromText.getPsi()));
            };
            commandProcessor.runUndoTransparentAction(runnable);
        });
        return (JSExpression)result.get();
    }
}

