/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingIndexableSetContributor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSIndexedRootProvider
extends ScriptingIndexableSetContributor {
    private volatile Set<VirtualFile> myRequiredLibraryFiles;

    protected Set<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/index/JSIndexedRootProvider", "getPredefinedLibraryFiles"));
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        Set<VirtualFile> files = libraryManager.getPredefinedLibraryFiles();
        if (VfsUtilCore.hasInvalidFiles(files)) {
            files = libraryManager.rebuildPredefinedLibraryFilesAndGet();
        }
        return files;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedFilesToIndex() {
        Set<VirtualFile> files = this.myRequiredLibraryFiles;
        if (files == null || VfsUtilCore.hasInvalidFiles(files)) {
            this.myRequiredLibraryFiles = files = JSPredefinedLibraryProvider.getAllRequiredLibraryFiles();
        }
        Set<VirtualFile> set = files;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexedRootProvider", "getPredefinedFilesToIndex"));
        }
        return set;
    }

    public LibraryKind getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }
}

