/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;

public class JSLinterUtil {
    private JSLinterUtil() {
    }

    @NotNull
    public static NativeObject convertPredefToRhinoMap(@NotNull Object predef) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefToRhinoMap"));
        }
        HashMap map = new HashMap();
        if (predef instanceof String) {
            Map<String, Boolean> boolMap = JSLinterUtil.convertPredefStrToMap((String)predef);
            map.putAll(boolMap);
        } else if (predef instanceof List) {
            for (Object o : (List)predef) {
                if (!(o instanceof String)) continue;
                map.put((String)o, false);
            }
        } else if (predef instanceof Map) {
            for (Map.Entry entry : ((Map)predef).entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        NativeObject nativeObject = RhinoUtil.toRhinoMap(map);
        if (nativeObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefToRhinoMap"));
        }
        return nativeObject;
    }

    @NotNull
    public static NativeArray convertPredefStrToNativeArray(@NotNull String predef, @NotNull Scriptable scope) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        Map<String, Boolean> structure = JSLinterUtil.convertPredefStrToMap(predef);
        NativeArray array = RhinoUtil.toRhinoArray(ContainerUtil.newArrayList(structure.keySet()));
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        NativeArray nativeArray = array;
        if (nativeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        return nativeArray;
    }

    @NotNull
    private static Map<String, Boolean> convertPredefStrToMap(@NotNull String predef) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToMap"));
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        StringTokenizer st = new StringTokenizer(predef, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int ind = token.indexOf(58);
            String name = token;
            boolean readonly = false;
            if (ind >= 0) {
                String value = token.substring(ind + 1).trim();
                if (Boolean.toString(true).equals(value) || Boolean.toString(false).equals(value)) {
                    name = token.substring(0, ind).trim();
                    readonly = Boolean.parseBoolean(value);
                }
            }
            map.put(name, readonly);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToMap"));
        }
        return linkedHashMap;
    }

    @Nullable
    public static Annotation createWarningAnnotation(@NotNull AnnotationHolder holder, @NotNull TextRange textRange, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        Annotation annotation = holder.createWarningAnnotation(textRange, message);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @Nullable
    public static Annotation createWarningAnnotation(@NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createWarningAnnotation"));
        }
        Annotation annotation = holder.createWarningAnnotation(element, message);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @Nullable
    public static Annotation createErrorAnnotation(@NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterUtil", "createErrorAnnotation"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSLinterUtil", "createErrorAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createErrorAnnotation"));
        }
        Annotation annotation = holder.createErrorAnnotation(element, message);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @Nullable
    public static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (forcedTextAttributes != null) {
            Annotation annotation = holder.createAnnotation(severity, range, message);
            annotation.setEnforcedTextAttributes(forcedTextAttributes);
            annotation.setNeedsUpdateOnTyping(false);
            return annotation;
        }
        Annotation annotation = severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(range, message) : holder.createWarningAnnotation(range, message);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @NotNull
    public static HighlightSeverity getSeverity(@NotNull InspectionProjectProfileManager inspectionProjectProfileManager, @NotNull HighlightDisplayKey inspectionKey, @NotNull PsiFile file) {
        if (inspectionProjectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProjectProfileManager", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        InspectionProfileImpl inspectionProfile = inspectionProjectProfileManager.getCurrentProfile();
        HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(inspectionKey, (PsiElement)file);
        if (errorLevel == null) {
            errorLevel = HighlightDisplayLevel.WARNING;
        }
        HighlightSeverity highlightSeverity = errorLevel.getSeverity();
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        return highlightSeverity;
    }

    @NotNull
    public static TextAttributes getTextAttributes(@Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightSeverity severity) {
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        TextAttributes textAttributes = severityRegistrar.getTextAttributesBySeverity(severity);
        if (textAttributes != null) {
            TextAttributes textAttributes2 = textAttributes;
            if (textAttributes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
            }
            return textAttributes2;
        }
        EditorColorsScheme colorsScheme = JSLinterUtil.getColorsScheme(editorColorsScheme);
        HighlightInfoType.HighlightInfoTypeImpl infoType = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
        TextAttributesKey key = infoType.getAttributesKey();
        TextAttributes textAttributes3 = colorsScheme.getAttributes(key);
        if (textAttributes3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        return textAttributes3;
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getColorsScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public static List<JSLinterError> limitErrorsAtTheSamePosition(@NotNull List<JSLinterError> errors, int limit) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterUtil", "limitErrorsAtTheSamePosition"));
        }
        Collections.sort(errors, (o1, o2) -> o1.compareFully((JSLinterError)o2));
        JSLinterError prev = null;
        ArrayList limited = ContainerUtil.newArrayList();
        int count = 0;
        for (JSLinterError error : errors) {
            if (prev != null && prev.compareLogicalPositionTo(error) == 0) {
                if (prev.getDescription().equals(error.getDescription())) continue;
                ++count;
            } else {
                count = 1;
            }
            if (count <= limit) {
                limited.add(error);
            }
            prev = error;
        }
        ArrayList arrayList = limited;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "limitErrorsAtTheSamePosition"));
        }
        return arrayList;
    }

    @NotNull
    public static TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull Project project, @NotNull String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        JTextField textField = (JTextField)textFieldWithBrowseButton.getChildComponent();
        textField.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
        textFieldWithBrowseButton.addBrowseFolderListener(description, null, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, (Disposable)project);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public static JEditorPane createDefaultContent(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDefaultContent"));
        }
        JEditorPane jEditorPane = JSLinterUtil.createHtmlViewer(message, null);
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDefaultContent"));
        }
        return jEditorPane;
    }

    @NotNull
    public static JEditorPane createHtmlViewer(@NotNull String innerBodyHtml, @Nullable Font font) {
        if (innerBodyHtml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerBodyHtml", "com/intellij/lang/javascript/linter/JSLinterUtil", "createHtmlViewer"));
        }
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        JEditorPane pane = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null), innerBodyHtml);
        pane.setText(html);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createHtmlViewer"));
        }
        return jEditorPane;
    }

    public static int getRadioIconWidth() {
        Icon icon = UIManager.getIcon("RadioButton.icon");
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 12;
    }

    public static String findPackageForNodePath(@NotNull Project project, @Nullable String nodePath, String packageName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "findPackageForNodePath"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = nodePath != null ? new NodeSettings(nodePath) : null;
        NodeModuleSearchUtil.findModulesWithName(list, packageName, project.getBaseDir(), nodeSettings, true);
        for (CompletionModuleInfo info : list) {
            VirtualFile virtualFile = info.getVirtualFile();
            if (virtualFile == null) continue;
            return FileUtil.toSystemDependentName((String)virtualFile.getPath());
        }
        return null;
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "isPureHtmlFile"));
        }
        if (file.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }

    @NotNull
    public static List<String> detectAllPackageDirs(Project project, String packageName, NodeJsLocalInterpreter interpreter) {
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project, true, NodeSettings.create(interpreter), true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "detectAllPackageDirs"));
        }
        return arrayList;
    }
}

