/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.jscs.JscsObsoleteRulesWarning;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsTypeError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.StdXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsCheckStyleOutputFormatParser
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private static final String UNSUPPORTED_RULE = "Unsupported rule:";
    private static final String RULE_IS_NO_LONGER_SUPPORTED = "rule is no longer supported";
    private static final String PLEASE_USE_OTHER = "Please use the following rules instead";
    private static final String NO_FILE_FOUND = "No configuration found. Add a .jscsrc file to your project root or use the -c option.";
    private static final String NO_FILE_FOUND_CORRECTED = "JSCS: No configuration found.";
    private final List<JSLinterError> myErrors;
    private List<String> myObsoleteRulesUsed;
    private List<String> myUnsupportedRulesUsed;
    private final StringBuilder myGlobalError;
    private JSLinterErrorBase myParsedGlobalError;
    private final StringBuilder myText;
    private final String myTmpFile;
    private static final String TYPE_ERROR = "TypeError:";
    private static final String ASSERTION_ERROR = "AssertionError:";
    private static final String OPTION_REQUIRES = "option requires";
    private static final String UNSUPPORTED_RULES = "Error: Unsupported rules:";

    public JscsCheckStyleOutputFormatParser(String actualCodeFile) {
        this.myTmpFile = actualCodeFile;
        this.myErrors = new ArrayList<JSLinterError>();
        this.myGlobalError = new StringBuilder();
        this.myText = new StringBuilder();
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        String text = event.getText().trim();
        if (outputType == ProcessOutputTypes.STDERR) {
            String textToAdd = NO_FILE_FOUND.equals(text) ? NO_FILE_FOUND_CORRECTED : text;
            this.myGlobalError.append(textToAdd).append("\n");
        } else if (outputType == ProcessOutputTypes.STDOUT) {
            this.myText.append(text).append("\n");
        }
    }

    public void process() {
        String text = this.myText.toString();
        if (!StringUtil.isEmptyOrSpaces((String)text)) {
            this.parseStdOut(text);
        }
        if (this.myGlobalError.length() > 0) {
            String message = JscsCheckStyleOutputFormatParser.tryParseExceptionMessage(this.myGlobalError.toString());
            this.myParsedGlobalError = message != null ? JscsCheckStyleOutputFormatParser.parseGlobalError(message) : new JSLinterError(0, 0, this.myGlobalError.toString(), null);
        }
    }

    private static JSLinterErrorBase parseGlobalError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "parseGlobalError"));
        }
        message = message.trim();
        String optionName = null;
        if (message.startsWith(ASSERTION_ERROR)) {
            JscsOption option;
            int endPhraseIdx = message.indexOf(OPTION_REQUIRES);
            if (endPhraseIdx > 0 && (option = JscsOption.safeValueOf(optionName = message.substring(ASSERTION_ERROR.length(), endPhraseIdx).trim())) != null) {
                return new JSLinterErrorBase(message, option.name());
            }
        } else {
            if (message.startsWith(UNSUPPORTED_RULES)) {
                return new JSLinterErrorBase(message, message.substring(UNSUPPORTED_RULES.length()).trim());
            }
            if (message.startsWith(TYPE_ERROR)) {
                return new JscsTypeError(message);
            }
        }
        return new JSLinterErrorBase(message);
    }

    private void parseStdOut(String text) {
        StdXMLBuilder builder = new StdXMLBuilder();
        NanoXmlUtil.parse((Reader)new StringReader(text), (IXMLBuilder)builder);
        IXMLElement root = (IXMLElement)builder.getResult();
        if (root == null) {
            LOG.debug("JSCS: Failed to parse jscs output: " + text);
            return;
        }
        try {
            JscsCheckStyleOutputFormatParser.expect(root, "checkstyle");
            if (root.getChildrenCount() != 1) {
                LOG.debug("JSCS: not one file returned when asked for " + this.myTmpFile + " returned " + root.getChildrenCount());
                return;
            }
            IXMLElement file = root.getChildAtIndex(0);
            JscsCheckStyleOutputFormatParser.expect(file, "file");
            int numErrors = file.getChildrenCount();
            for (int i = 0; i < numErrors; ++i) {
                IXMLElement error = file.getChildAtIndex(i);
                JscsCheckStyleOutputFormatParser.expect(error, "error");
                this.parseError(error);
            }
        }
        catch (MyHomeException e) {
            LOG.debug("JSCS: expected " + e.getMessage() + " but found " + e.getElement().getName() + " Text:\n" + this.myText);
        }
    }

    public List<JSLinterError> getErrors() {
        return this.myErrors;
    }

    @Nullable
    public List<JscsObsoleteRulesWarning> getWarnings() {
        if (this.myObsoleteRulesUsed == null && this.myUnsupportedRulesUsed == null) {
            return null;
        }
        ArrayList<JscsObsoleteRulesWarning> warnings = new ArrayList<JscsObsoleteRulesWarning>();
        if (this.myObsoleteRulesUsed != null) {
            warnings.add(new JscsObsoleteRulesWarning("rules are no longer supported: " + StringUtil.join(this.myObsoleteRulesUsed, (String)", "), this.myObsoleteRulesUsed));
        }
        if (this.myUnsupportedRulesUsed != null) {
            warnings.add(new JscsObsoleteRulesWarning("Unsupported rules: " + StringUtil.join(this.myUnsupportedRulesUsed, (String)", "), this.myUnsupportedRulesUsed));
        }
        return warnings;
    }

    public JSLinterErrorBase getGlobalError() {
        return this.myParsedGlobalError;
    }

    private void parseError(IXMLElement error) {
        String code;
        String message = error.getAttribute("message", "");
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return;
        }
        int colonIdx = message.indexOf(":");
        String string = code = colonIdx <= 0 ? "" : message.substring(0, colonIdx).trim();
        if (message.contains(RULE_IS_NO_LONGER_SUPPORTED) && message.contains(PLEASE_USE_OTHER)) {
            if (!code.isEmpty()) {
                if (this.myObsoleteRulesUsed == null) {
                    this.myObsoleteRulesUsed = new ArrayList<String>();
                }
                this.myObsoleteRulesUsed.add(code);
            }
            return;
        }
        if (message.contains(UNSUPPORTED_RULE)) {
            String string2 = code = colonIdx <= 0 ? "" : message.substring(colonIdx + 1).trim();
            if (!code.isEmpty()) {
                if (this.myUnsupportedRulesUsed == null) {
                    this.myUnsupportedRulesUsed = new ArrayList<String>();
                }
                this.myUnsupportedRulesUsed.add(code);
            }
            return;
        }
        message = colonIdx > 0 ? message.substring(colonIdx + 1) : message;
        Integer line = this.readLineOrCol(error, "line");
        Integer col = this.readLineOrCol(error, "column");
        if (line != null && col != null) {
            this.myErrors.add(new JSLinterError(line, col, message.trim(), code));
        }
    }

    private static String tryParseExceptionMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "tryParseExceptionMessage"));
        }
        String[] lines = message.split("\n");
        if (lines.length == 1) {
            return null;
        }
        boolean atFound = false;
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i].trim();
            if (line.isEmpty()) continue;
            if (JscsCheckStyleOutputFormatParser.isExceptionLine(line)) {
                atFound = true;
                continue;
            }
            if (atFound) {
                LOG.debug("JSCS: " + message);
                return line;
            }
            return null;
        }
        return null;
    }

    private static boolean isExceptionLine(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "isExceptionLine"));
        }
        int at = s.indexOf("at ");
        if (at < 0) {
            return false;
        }
        if (s.indexOf("native", at) > 0) {
            return true;
        }
        int from = at;
        while (from < s.length()) {
            int dotIdx = s.indexOf(":", from);
            if (dotIdx < 0 || dotIdx == s.length() - 1) {
                return false;
            }
            if (Character.isDigit(s.charAt(dotIdx + 1))) {
                return true;
            }
            from = dotIdx + 1;
        }
        return false;
    }

    private Integer readLineOrCol(@NotNull IXMLElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "readLineOrCol"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "readLineOrCol"));
        }
        String line = element.getAttribute(name, "");
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            LOG.debug("JSCS: when checking file " + this.myTmpFile + " message without " + name + ": " + element.getAttribute("message", ""));
            return null;
        }
        try {
            return Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            LOG.debug("JSCS: when checking file " + this.myTmpFile + " " + name + " is not a number for message " + element.getAttribute("message", ""));
            return null;
        }
    }

    private static void expect(@NotNull IXMLElement element, @NotNull String name) throws MyHomeException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "expect"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/JscsCheckStyleOutputFormatParser", "expect"));
        }
        if (!name.equals(element.getName())) {
            throw new MyHomeException(name, element);
        }
    }

    private static class MyHomeException
    extends Exception {
        private final IXMLElement myElement;

        public MyHomeException(String message, IXMLElement element) {
            super(message);
            this.myElement = element;
        }

        public IXMLElement getElement() {
            return this.myElement;
        }
    }
}

