/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHintConfigFileAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotate"));
        }
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)element, JsonFile.class);
        if (file != null && JSHintConfigFileUtil.isJSHintConfigFile((PsiFile)file)) {
            JSHintConfigFileAnnotator.annotateFile(file, holder);
        }
    }

    private static void annotateFile(@NotNull JsonFile file, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateFile"));
        }
        for (PsiElement element : file.getChildren()) {
            JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (objectLiteralExpression == null) continue;
            JSHintConfigFileAnnotator.annotateObjectLiteralExpression(objectLiteralExpression, holder);
        }
    }

    private static void annotateObjectLiteralExpression(@NotNull JsonObject expression, @NotNull AnnotationHolder holder) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateObjectLiteralExpression"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateObjectLiteralExpression"));
        }
        List properties = expression.getPropertyList();
        EnumMap<JSHintOption, PsiElement> encounteredOptions = new EnumMap<JSHintOption, PsiElement>(JSHintOption.class);
        for (JsonProperty property : properties) {
            JSHintConfigFileAnnotator.annotateJSProperty(property, holder, encounteredOptions);
        }
    }

    private static void annotateJSProperty(@NotNull JsonProperty property, @NotNull AnnotationHolder holder, @NotNull Map<JSHintOption, PsiElement> encounteredOptions) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSProperty"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSProperty"));
        }
        if (encounteredOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encounteredOptions", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSProperty"));
        }
        PsiElement keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (keyElement == null) {
            return;
        }
        String keyStr = StringUtil.stripQuotesAroundValue((String)keyElement.getText());
        if ("extends".equals(keyStr)) {
            return;
        }
        JSHintOption option = JSHintOption.findByName(keyStr);
        if (option == null) {
            if (!JSHintConfigFileUtil.isWarningKey(keyStr)) {
                JSHintConfigFileAnnotator.annotateJSPropertyKeyAsUnknown(keyElement, holder);
            }
            return;
        }
        PsiElement oldKeyElement = encounteredOptions.get(option);
        if (oldKeyElement != null) {
            JSHintConfigFileAnnotator.annotateJSPropertyKeyAsDuplicated(oldKeyElement, keyElement, holder);
            return;
        }
        encounteredOptions.put(option, keyElement);
        JSHintConfigFileAnnotator.annotateJSPropertyValue(property, option, holder);
    }

    private static void annotateJSPropertyKeyAsUnknown(@NotNull PsiElement keyElement, @NotNull AnnotationHolder holder) {
        if (keyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyElement", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyKeyAsUnknown"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyKeyAsUnknown"));
        }
        JSHintConfigFileAnnotator.annotateKeyElement(keyElement, holder, "Unexpected JSHint option name");
    }

    private static void annotateJSPropertyKeyAsDuplicated(@NotNull PsiElement oldKeyElement, @NotNull PsiElement newKeyElement, @NotNull AnnotationHolder holder) {
        String newKeyStr;
        if (oldKeyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldKeyElement", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyKeyAsDuplicated"));
        }
        if (newKeyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newKeyElement", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyKeyAsDuplicated"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyKeyAsDuplicated"));
        }
        String oldKeyStr = StringUtil.stripQuotesAroundValue((String)oldKeyElement.getText());
        if (!oldKeyStr.equals(newKeyStr = StringUtil.stripQuotesAroundValue((String)newKeyElement.getText()))) {
            String message = "Duplicate JSHint options: " + oldKeyStr + ", " + newKeyStr + ".";
            JSHintConfigFileAnnotator.annotateKeyElement(oldKeyElement, holder, message);
            JSHintConfigFileAnnotator.annotateKeyElement(newKeyElement, holder, message);
        }
    }

    private static void annotateKeyElement(@NotNull PsiElement keyElement, @NotNull AnnotationHolder holder, @NotNull String message) {
        int endInd;
        int startInd;
        if (keyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyElement", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateKeyElement"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateKeyElement"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateKeyElement"));
        }
        TextRange textRange = keyElement.getTextRange();
        if (JSLinterConfigFileUtil.isStringLiteral(keyElement) && (startInd = textRange.getStartOffset() + 1) < (endInd = textRange.getEndOffset() - 1)) {
            textRange = new TextRange(startInd, endInd);
        }
        if (!textRange.isEmpty()) {
            holder.createWarningAnnotation(textRange, message);
        }
    }

    private static void annotateJSPropertyValue(@NotNull JsonProperty property, @NotNull JSHintOption option, @NotNull AnnotationHolder holder) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyValue"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "annotateJSPropertyValue"));
        }
        JsonValue value = property.getValue();
        if (value == null) {
            return;
        }
        if (option == JSHintOption.PREDEF) {
            if (!(value instanceof JsonObject) && !(value instanceof JsonArray)) {
                holder.createWarningAnnotation((PsiElement)value, "object or array expected");
            }
            return;
        }
        String valueStr = value.getText();
        Object unifiedValue = option.getType().fromString(valueStr);
        if (unifiedValue != null) {
            return;
        }
        String message = JSHintConfigFileAnnotator.formatErrorMessageFor(option);
        holder.createWarningAnnotation((PsiElement)value, message);
    }

    private static String formatErrorMessageFor(@NotNull JSHintOption option) {
        String message;
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator", "formatErrorMessageFor"));
        }
        List validVariants = Collections.emptyList();
        if (OptionTypes.isEnumOption(option)) {
            OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
            validVariants = ContainerUtil.map(enumType.getVariants(), variant -> variant.getValueAsJsonStr());
        } else if (OptionTypes.isBooleanOption(option)) {
            validVariants = ContainerUtil.newArrayList((Object[])new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
        }
        if (validVariants.size() > 0) {
            StringBuilder buf = new StringBuilder("Expected values: ");
            StringUtil.join(validVariants.subList(0, validVariants.size() - 1), (String)", ", (StringBuilder)buf);
            buf.append(" or ").append((String)validVariants.get(validVariants.size() - 1));
            message = buf.toString();
        } else {
            message = "unexpected value";
        }
        return message;
    }
}

