/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.jslint.JSLintInspection;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import com.intellij.lang.javascript.linter.jslint.JSLintOptionsState;
import com.intellij.lang.javascript.linter.jslint.JSLintState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JSLintConfiguration", storages={@Storage(value="jsLinters/jslint.xml")})
public class JSLintConfiguration
extends JSLinterConfiguration<JSLintState> {
    private static final String IS_JSON_VALIDATED_ATTRIBUTE_NAME = "json";
    private static final String ROOT_ELEMENT_NAME = "jslint";
    private static final String OPTION_ELEMENT_NAME = "option";
    private static final JSLintState DEFAULT_STATE = new JSLintState.Builder().setOptionsState(new JSLintOptionsState.Builder().put(JSLintOption.MAXERR, 50).build()).build();

    public JSLintConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "<init>"));
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull JSLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "savePrivateSettings"));
        }
    }

    @Override
    @NotNull
    protected JSLintState loadPrivateSettings(@NotNull JSLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "loadPrivateSettings"));
        }
        JSLintState jSLintState = state;
        if (jSLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "loadPrivateSettings"));
        }
        return jSLintState;
    }

    @NotNull
    public static JSLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getInstance"));
        }
        JSLintConfiguration jSLintConfiguration = JSLintConfiguration.getInstance(project, JSLintConfiguration.class);
        if (jSLintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getInstance"));
        }
        return jSLintConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (JSLintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getInspectionClass"));
        }
        return JSLintInspection.class;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull JSLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "toXml"));
        }
        Element root = new Element(ROOT_ELEMENT_NAME);
        JSLintConfiguration.addBooleanAttribute(root, state.isValidateJson(), IS_JSON_VALIDATED_ATTRIBUTE_NAME);
        JSLintOptionsState optionsState = state.getOptionsState();
        for (JSLintOption option : optionsState.getOptions()) {
            Object value = optionsState.getValue(option);
            if (value == null) continue;
            Element child = new Element(OPTION_ELEMENT_NAME);
            child.setAttribute(option.getOptionName(), value.toString());
            root.addContent(child);
        }
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "toXml"));
        }
        return element;
    }

    @Override
    @NotNull
    protected JSLintState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "fromXml"));
        }
        JSLintState.Builder builder = new JSLintState.Builder();
        builder.setValidateJson(JSLintConfiguration.getBooleanAttrValue(element, IS_JSON_VALIDATED_ATTRIBUTE_NAME));
        JSLintOptionsState optionsState = JSLintConfiguration.loadOptionsValues(element.getChildren());
        builder.setOptionsState(optionsState);
        JSLintState jSLintState = builder.build();
        if (jSLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "fromXml"));
        }
        return jSLintState;
    }

    @NotNull
    private static JSLintOptionsState loadOptionsValues(@NotNull List<Element> optionsElements) {
        if (optionsElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsElements", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "loadOptionsValues"));
        }
        JSLintOptionsState.Builder optionsValuesBuilder = new JSLintOptionsState.Builder();
        for (Element child : optionsElements) {
            if (!OPTION_ELEMENT_NAME.equals(child.getName())) continue;
            List attributes = child.getAttributes();
            for (Attribute attribute : attributes) {
                Object value;
                String optionName = attribute.getName();
                String valueStr = StringUtil.notNullize((String)attribute.getValue());
                JSLintOption option = JSLintOption.findByName(optionName);
                if (option == null || (value = option.getType().createObject(valueStr)) == null) continue;
                optionsValuesBuilder.put(option, value);
            }
        }
        JSLintOptionsState jSLintOptionsState = optionsValuesBuilder.build();
        if (jSLintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "loadOptionsValues"));
        }
        return jSLintOptionsState;
    }

    private static void addBooleanAttribute(@NotNull Element element, boolean value, @NotNull String key) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "addBooleanAttribute"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "addBooleanAttribute"));
        }
        if (value) {
            element.setAttribute(key, Boolean.TRUE.toString());
        }
    }

    private static boolean getBooleanAttrValue(@NotNull Element element, @NotNull String attrName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getBooleanAttrValue"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getBooleanAttrValue"));
        }
        String value = element.getAttributeValue(attrName);
        return Boolean.parseBoolean(value);
    }

    @Override
    @NotNull
    protected JSLintState getDefaultState() {
        JSLintState jSLintState = DEFAULT_STATE;
        if (jSLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintConfiguration", "getDefaultState"));
        }
        return jSLintState;
    }
}

