/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleUtil {
    @NonNls
    public static final String NODE_MODULES = "node_modules";
    public static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        int cnt2;
        String path1 = o1.getPath();
        String path2 = o2.getPath();
        int cnt1 = StringUtil.countChars((CharSequence)path1, (char)'/');
        if (cnt1 != (cnt2 = StringUtil.countChars((CharSequence)path2, (char)'/'))) {
            return cnt1 - cnt2;
        }
        return path1.compareTo(path2);
    };
    private static final Key<Ref<VirtualFile>> ourModuleRoot = Key.create((String)"NodeJs.Current.Module.Root");

    public static boolean isModuleFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isModuleFile"));
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType())) {
            return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(file);
        }
        return false;
    }

    @Nullable
    public static VirtualFile getProjectChildModuleByName(@NotNull Project project, @NotNull VirtualFile moduleRoot, @NotNull String name) {
        Object nodeModules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/NodeModuleUtil", "getProjectChildModuleByName"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/intellij/lang/javascript/modules/NodeModuleUtil", "getProjectChildModuleByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/NodeModuleUtil", "getProjectChildModuleByName"));
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        boolean projectScope = moduleRoot.equals(project.getBaseDir());
        if (projectScope && (nodeModules = moduleRoot.findChild(NODE_MODULES)) != null) {
            return nodeModules.findChild(name);
        }
        nodeModules = new ArrayList(FilenameIndex.getVirtualFilesByName((Project)project, (String)NODE_MODULES, (GlobalSearchScope)scope));
        if (nodeModules.isEmpty()) {
            return null;
        }
        Collections.sort(nodeModules, (o1, o2) -> o1.getUrl().compareTo(o2.getUrl()));
        Iterator iterator = nodeModules.iterator();
        while (iterator.hasNext()) {
            VirtualFile child;
            VirtualFile root = (VirtualFile)iterator.next();
            String path = VfsUtilCore.getRelativePath((VirtualFile)root.getParent(), (VirtualFile)moduleRoot);
            if (path == null || path.contains(NODE_MODULES) || (child = root.findChild(name)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ForRequireModuleInfo canBeRequired(Project project, VirtualFile mainModuleRoot, PsiFile targetPsiFile, boolean checkForNodeLibraryAssociation) {
        VirtualFile current;
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        if (!NodeModuleSearchUtil.canLoadFile(targetFile) || checkForNodeLibraryAssociation && !NodeModuleUtil.isLocalModuleOrNodeModulesLibrary(targetPsiFile, targetFile)) {
            return null;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)mainModuleRoot, (VirtualFile)targetFile, (boolean)true)) {
            VirtualFile moduleRoot = JSLibraryUtil.getLibraryFolder(targetFile, NODE_MODULES);
            if (moduleRoot == null) {
                Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(mainModuleRoot);
                return new ForRequireModuleInfo(mainModuleRoot, targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.EXACT_PATH);
            }
            return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile moduleRoot = NodeModuleUtil.findModuleRoot(baseDir, current = targetFile.getParent());
        if (moduleRoot == null) {
            return null;
        }
        return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
    }

    private static boolean isLocalModuleOrNodeModulesLibrary(PsiFile targetPsiFile, VirtualFile targetFile) {
        return NodeModuleUtil.isModuleFile(targetPsiFile) || JSLibraryUtil.isProbableLibraryFile(targetFile) && JSLibraryUtil.hasDirectoryInPath(targetFile, NODE_MODULES, null);
    }

    @NotNull
    private static ForRequireModuleInfo addFromChildModule(VirtualFile targetFile, VirtualFile moduleRoot) {
        Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(moduleRoot);
        ForRequireModuleInfo forRequireModuleInfo = new ForRequireModuleInfo(moduleRoot, targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.NODE_MODULES_DIR);
        if (forRequireModuleInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NodeModuleUtil", "addFromChildModule"));
        }
        return forRequireModuleInfo;
    }

    @Nullable
    private static VirtualFile findModuleRoot(VirtualFile baseDir, VirtualFile current) {
        VirtualFile moduleRoot = null;
        while (current != null && !baseDir.equals(current)) {
            if (current.getParent() != null && NODE_MODULES.equals(current.getParent().getName())) {
                moduleRoot = current;
                break;
            }
            current = current.getParent();
        }
        return moduleRoot;
    }

    public static VirtualFile getMainModuleRoot(LocalInspectionToolSession session) {
        VirtualFile moduleRoot;
        Ref ref = (Ref)session.getUserData(ourModuleRoot);
        if (ref == null) {
            PsiFile psiFile = session.getFile();
            moduleRoot = NodeModuleUtil.findMainModuleRoot(psiFile.getProject(), psiFile.getVirtualFile());
            session.putUserData(ourModuleRoot, (Object)new Ref((Object)moduleRoot));
        } else {
            moduleRoot = (VirtualFile)ref.get();
        }
        return moduleRoot;
    }

    private static VirtualFile findMainModuleRoot(Project project, VirtualFile file) {
        VirtualFile current;
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile contentRoot = NodeModuleUtil.findParentContentRoot(project, file);
        if (contentRoot == null) {
            return null;
        }
        VirtualFile virtualFile = current = file.isDirectory() ? file : file.getParent();
        while (current != null) {
            VirtualFile packageJson = current.findChild("package.json");
            if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
                return current;
            }
            if (baseDir.equals(current)) {
                return baseDir;
            }
            current = current.getParent();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findParentContentRoot(Project project, VirtualFile file) {
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        VirtualFile contentRoot = null;
        for (VirtualFile root : contentRoots) {
            if (!root.equals(VfsUtilCore.getCommonAncestor((VirtualFile)root, (VirtualFile)file))) continue;
            contentRoot = root;
            break;
        }
        return contentRoot;
    }

    public static boolean isForNode(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isForNode"));
        }
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isForNode"));
        }
        return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(project, vf);
    }

    public static boolean isWrappedInAmdDefinition(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isWrappedInAmdDefinition"));
        }
        return JSAmdUtil.getCachedWrappingAmdDefinition(element) != null;
    }

    public static boolean isResolvedGloballyCommonJS(@NotNull ResolveResult result, @NotNull Set<VirtualFile> predefinedFiles, @NotNull LocalInspectionToolSession session) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isResolvedGloballyCommonJS"));
        }
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isResolvedGloballyCommonJS"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isResolvedGloballyCommonJS"));
        }
        return result.isValidResult() && result.getElement() != null && (predefinedFiles.contains(result.getElement().getContainingFile().getVirtualFile()) || NodeModuleUtil.isResolvedGloballyForTypescript(result.getElement(), session) || NodeModuleUtil.isResolvedGloballyForNode(result));
    }

    private static boolean isResolvedGloballyForTypescript(@NotNull PsiElement element, LocalInspectionToolSession session) {
        VirtualFile typescript;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isResolvedGloballyForTypescript"));
        }
        VirtualFile moduleRoot = NodeModuleUtil.getMainModuleRoot(session);
        if (moduleRoot != null && (typescript = NodeModuleUtil.getProjectChildModuleByName(element.getProject(), moduleRoot, "typescript")) != null) {
            return VfsUtil.isAncestor((VirtualFile)typescript, (VirtualFile)element.getContainingFile().getVirtualFile(), (boolean)true);
        }
        return false;
    }

    public static boolean isResolvedGloballyForNode(@NotNull ResolveResult result) {
        JSQualifiedName qualifier;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isResolvedGloballyForNode"));
        }
        return result.getElement() != null && result.getElement() instanceof JSDefinitionExpression && (qualifier = ((JSDefinitionExpression)result.getElement()).getNamespace()) != null && "global".equals(qualifier.getName());
    }

    public static boolean isFromNodeModules(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isFromNodeModules"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/NodeModuleUtil", "isFromNodeModules"));
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file);
        if (nodeModulesDir == null) {
            return false;
        }
        return NodeModuleUtil.findParentContentRoot(project, nodeModulesDir) == null && !VfsUtil.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)nodeModulesDir, (boolean)true);
    }

    @Nullable
    public static VirtualFile findNodeModulesByPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        VirtualFile parent;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/NodeModuleUtil", "findNodeModulesByPackageJson"));
        }
        VirtualFile virtualFile = parent = packageJson.isDirectory() ? null : packageJson.getParent();
        if (parent != null && (nodeModulesDir = parent.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory()) {
            return nodeModulesDir;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findPackageJsonByNodeModules(@NotNull VirtualFile nodeModules) {
        VirtualFile packageJson;
        VirtualFile parent;
        if (nodeModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModules", "com/intellij/lang/javascript/modules/NodeModuleUtil", "findPackageJsonByNodeModules"));
        }
        VirtualFile virtualFile = parent = nodeModules.isDirectory() ? nodeModules.getParent() : null;
        if (parent != null && (packageJson = parent.findChild("package.json")) != null && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/NodeModuleUtil", "findUpClosestNodeModulesResolveRoot"));
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            VirtualFile nodeModulesDir = parent.findChild(NODE_MODULES);
            if (nodeModulesDir == null || !nodeModulesDir.isDirectory()) continue;
            return nodeModulesDir;
        }
        return null;
    }
}

